package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.po.MktContentChannelSourceActionPO;
import com.bizvane.mktcenterservice.models.vo.MemberChannelDetailVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;

public interface MemberSourceService {

    /**
     * 查询 会员特定动作/事件 的来源信息
     * @param sysBrandId 品牌id
     * @param memberCode 会员编号
     * @param actionTypes 会员的动作/事件类型：1.浏览，2.注册，3绑定，4点亮俱乐部
     * @return
     */
    MktContentChannelSourceActionPO getMembersSourceByMemberCodeAndActionType(Long sysBrandId, String memberCode, Integer[] actionTypes);

    /**
     * 分页查询 会员渠道记录明细
     * @param requestVo
     * @return
     */
    ResponseData<PageInfo<MktContentChannelSourceActionPO>> getMemberAllSourceActionInfo(MemberChannelDetailVO requestVo);
}
