package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Ljc
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ReceiveActivityRulesVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 发总礼包数
     */
    private Integer totalGiftbagNum;

    /**
     * 是否限制发礼包数量 0:不限 1:限制
     */
    private String limitGiftBagNum;

    /**
     * 活动发券总数 数字限制
     */
    private Integer totalCouponNum;

    /**
     * 是否限制发券数量 0:不限 1:限制
     */
    private String limitCouponNum;

    /**
     * 领券方式 扫码:SCANCODE 手动:MANUAL
     */
    private String receiveType;

    /**
     * 每人最多参与次数
     */
    private Integer perPersonPerMax;

    /**
     * 每人每日参与次数
     */
    private Integer perPersonPerDayMax;

    /**
     * 会员信息
     */
    private MktMemActivityGroupVO mbrGroup;

}
