package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @description: 年龄分布Vo
 * @author: Liu Xinpeng
 * @create: 2020-08-10 15:37
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class MemberPortraitAgeVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 小于50后，这里指的小于，是出生日期的年数小于
     */
    private String lessFifty;

    /**
     * 50后
     */
    private String fifty;
    /**
     * 60后
     */
    private String sixty;

    /**
     * 70后
     */
    private String seventy;

    /**
     * 80后
     */
    private String eighty;

    /**
     * 90后
     */
    private String ninety;

    /**
     * 00 后
     */
    private String zeroZero;

    /**
     * > = 00后
     */
    private String greaterOrEqualZeroZero;


}