package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.TaskAwardBO;
import com.bizvane.mktcenterservice.models.bo.TotalStatisticsBO;
import com.bizvane.mktcenterservice.models.po.MktTaskRecordPO;
import com.bizvane.mktcenterservice.models.requestvo.TaskRecordReqVO;
import com.bizvane.mktcenterservice.models.vo.DayTaskRecordVo;
import com.bizvane.mktcenterservice.models.vo.MktTaskRecordVO;
import com.bizvane.mktcenterservice.models.vo.TaskAnalysisVo;
import com.bizvane.mktcenterservice.models.vo.TaskRecordResVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @Author: lijunwei
 * @Time: 2018/8/6 23:44
 */
public interface TaskRecordService {
    /**
     * 添加记录
     * @param vo
     * @return
     */
    public Long addTaskRecord(MktTaskRecordPO vo);

    /**
     * 修改记录
     * @return
     */
    public Integer updateTaskRecord(MktTaskRecordPO po);

    /**
     * 修改受邀者记录
     * @return
     */
    public Integer updateInviteeTaskRecord(MktTaskRecordPO po);

    /**
     * 查询
     * @param vo
     * @return
     */
    public TotalStatisticsBO getTotalStatistics(MktTaskRecordVO vo) ;

    /**
     * 判断是否获取过奖励
     * @param vo
     * @return
     */
    public Boolean getIsOrNoAward(MktTaskRecordVO vo);

    /**
     * 效果分析
     * @param vo
     * @return
     */
    List<DayTaskRecordVo> getAnalysisResult(TaskAnalysisVo vo);

    public Long addTaskRecordNew(MktTaskRecordPO po);
    /**
     * 循环任务下判断可参与任务次数是否封顶
     * @param vo
     * @param taskAwardBO
     * @return
     */
    Boolean getIsOrNoAwardOnEvery(MktTaskRecordVO vo, TaskAwardBO taskAwardBO);

    /**
     * 获取会员某总成功参与奖励次数
     * @param memberCode
     * @param taskId
     * @return
     */
    long getRewardedTotalByMbrAndTaskId(String memberCode, Long taskId);

    /**
     * 邀请开卡记录明细
     * @param sysAccountPo
     * @param recordReqVO
     * @return
     */
    ResponseData<PageInfo<TaskRecordResVO>> findInviteeRecordPage(SysAccountPO sysAccountPo, TaskRecordReqVO recordReqVO);

    /**
     * 邀请开卡记录明细导出
     * @param sysAccountPo
     * @param recordReqVO
     * @return
     */
    ResponseData<String> findInviteeRecordExport(SysAccountPO sysAccountPo, TaskRecordReqVO recordReqVO);
}
