package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.mktcenterservice.models.po.MktMessagePO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@Data
@ApiModel("线下报名活动视图类")
public class ActivityRegistrationVO {
    private Long mktActivityId;
    private Long sysBrandId;
    private String activityName;
    private String activityCode;
    private Long sysCompanyId;
    private Date startTime;
    private Date endTime;
    private Integer activityStatus;
    private Integer checkStatus;
    private String remark;
    private String pageUrl;
    private String qrCodeUrl;
    @ApiModelProperty(value="创建人id")
    private Long createUserId;
    private String createUserName;
    private Date createDate;
    private String activityDetailImg;
    private Integer activityInfoType;
    private String activityInfo;
    private Integer mbrConditionType;
    private String mbrCondition;
    @ApiModelProperty(value="pkid")
    private Long mktActivityRegistrationId;
    @ApiModelProperty(value="非会员是否可以报名 1=可以 0=不可以")
    private Boolean isSignupNoMember;
    @ApiModelProperty(value="报名费用类型：0=无需，1=积分")
    private Integer registrationFeeType;
    @ApiModelProperty(value="报名费用")
    private Integer registrationFee;
    @ApiModelProperty(value="报名人数限制")
    private Integer registrationNumberLimit;
    private Integer activityType;

    @ApiModelProperty(value="活动状态")
    private String activityStatusStr;
    @ApiModelProperty(value="是否报名")
    private Boolean isSignUp;
    /**
     * 报名所需资料 json
     */
    @ApiModelProperty("报名所需资料")
    private List<ExtendPropertyModel> customPropertiesList;
    private String customPropertiesJson;
    private List<MktMessagePO> messageList;
    private MbrGroupModel mbrGroupModel;

    @ApiModelProperty(value="报名途径 0自己报名 1别人帮自己报名")
    private Byte signUpSource;
    @ApiModelProperty(value="报名来源 0会员中心 1商秀")
    private Byte signUpOrigin;
    @ApiModelProperty(value="是否帮人报名 1:可以   0:不可以")
    private Byte isHelpRegistration;
    @ApiModelProperty(value="活动费用预算")
    private BigDecimal costEstimate;
    @ApiModelProperty(value="活动地点")
    private String registrationAddress;
    @ApiModelProperty(value="文字内容(商秀)")
    private String literalContent;
    @ApiModelProperty(value="上传图片(商秀)")
    private String photoUrl;
    @ApiModelProperty(value="报名总人数")
    private Integer signupTotalNumber;
    @ApiModelProperty(value="签到总人数")
    private Integer signinTotalNumber;

    //门店限制状态：0不限制，1限制
    private Boolean isStoreLimit;
    //门店限制类型：1黑名单，2白名单
    private Integer storeLimitType;
    //门店限制名单
    private String storeLimitList;


    @JsonIgnore
    public String getCustomPropertiesJson() {
        if (StringUtils.isNotBlank(customPropertiesJson)) {
            return customPropertiesJson;
        } else {
            return customPropertiesJson = JacksonUtil.bean2Json(customPropertiesList);
        }
    }

    public List<ExtendPropertyModel> getCustomPropertiesList() {
        if (CollectionUtils.isNotEmpty(customPropertiesList)) {
            return customPropertiesList;
        } else if (StringUtils.isNotBlank(customPropertiesJson)) {
            return customPropertiesList = JacksonUtil.json2List(customPropertiesJson, ExtendPropertyModel.class);
        } else {
            return Collections.emptyList();
        }
    }
}
