package com.bizvane.mktcenterservice.models.bo;

import com.bizvane.centerstageservice.models.po.SysStorePo;
import lombok.Data;

import java.util.Date;

/**
 * @author yuantq
 * @date 2022/5/29
 */
@Data
public class ActivityPrizeRecordDetailBO {
    /**
     * 中奖记录主键ID
     */
    private Long mktActivityPrizeRecordId;

    /**
     * 企业ID
     */
    private Long sysCompanyId;

    /**
     * 品牌ID
     */
    private Long sysBrandId;

    /**
     * 奖品名称
     */
    private String activityPrizeName;

    /**
     * 奖项类型 ，10-特等奖，20-一等奖，30-二等奖，40-三等奖，50-安慰奖 60-四等奖 依次
     */
    private Integer prizeType;

    /**
     * 奖品类型：10-积分，20-优惠券（现金，折扣）,30-兑换券（礼品券）40-实物奖品 50-微信红包封面
     */
    private Integer awadType;

    /**
     * 奖品状态 0.未兑换-且未填写兑换门店信息 1.已选择兑换门店(正常) 2.已兑换 3.已到期
     */
    private Integer prizeStatus;

    /**
     * 奖品图片
     */
    private String imageUrl;

    /**
     * 中奖时间
     */
    private Date prizeTime;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 提货时间限制是否开启	0.关闭(无限制) 1.开启(有限制)
     */
    private Integer pickUpTimeSwitch;

    /**
     * 提货开始时间
     */
    private Date pickUpBeginTime;

    /**
     * 提货结束时间
     */
    private Date pickUpEndTime;

    /**
     * 预约提货门店ID
     */
    private String storeScopeCode;

    /**
     * 提货门店信息
     */
    private SysStorePo sysStorePo;

    /**
     * 联系人
     */
    private String linkmanName;

    /**
     * 联系人手机号
     */
    private String linkmanPhone;

    /**
     * 实物奖品物流配置-省
     */
    private String linkmanProvince;

    /**
     * 实物奖品物流配置-市
     */
    private String linkmanCity;

    /**
     * 实物奖品物流配置-区
     */
    private String linkmanDistrict;

    /**
     * 联系人地址
     */
    private String linkmanAddress;

    /**
     * 奖品可提货门店code，逗号拼接
     */
    private String storeScopeIds;

    private Integer physicalExtractionType;

    /**
     * 门店范围类型：0.服务门店 1.指定门店
     */
    private Integer storeScopeType;

    private Integer exchangeType;

    private Date exchangeDeadline;

    /**
     * 实物兑奖剩余时间(提货期限)
     */
    private Integer entityExchangeDay;

    /**
     * 奖品状态(0.未填写提货方式及信息,1.已填写提货方式及信息,2.已提货,3.已过期)
     */
    private Integer entityPriceStatus;

}
