package com.bizvane.mktcenter.feign.vo.resp.mobile;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class QueryPointLotteryPageRespVO {

    @ApiModelProperty(value = "活动系统编号code")
    private String mktActivityCode;

    @ApiModelProperty(value = "活动状态：1待执行，2执行中，3已结束，4已禁用")
    private Integer activityStatus;

    @ApiModelProperty(value = "是否长期：1是，0否")
    private Integer longTerm;

    @ApiModelProperty(value = "活动开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "活动结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "奖品名称")
    private String prizeName;

    @ApiModelProperty(value = "奖品图片")
    private String prizeImage;

    @ApiModelProperty(value = "消耗积分")
    private Integer consumePoints;

    @ApiModelProperty(value = "奖品价格")
    private Integer prizePrice;

    @ApiModelProperty(value = "参与人数门槛")
    private Integer minParticipateNum;

    @ApiModelProperty(value = "已参与人次")
    private Integer joinedNum;

    @ApiModelProperty(value = "当前会员参与人次,人次：每个活动参与次数总数")
    private Integer currentMemberJoinedNum;

    @ApiModelProperty(value = "每人最多参与次数")
    private Integer maxPerPersonParticipationNum;

    @ApiModelProperty(value = "虚拟参与人数")
    private Integer baseParticipationNum;

    @ApiModelProperty(value = "开奖状态 0未开奖 1开奖中 2开奖成功 3开奖失败")
    private Integer drawPrizeStatus;

    @ApiModelProperty(value = "开奖时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime drawPrizeDate;

}
