package com.bizvane.mktcenter.feign.vo.resp.mobile;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class MobileQueryTaskListRespVO {

    @ApiModelProperty(value = "任务系统编号code")
    private String mktTaskCode;

    @ApiModelProperty(value = "任务编号")
    private String taskNo;

    @ApiModelProperty(value = "任务类型：1邀请入会2完善资料3会员乘机4调查问卷")
    private Integer taskType;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "是否长期：1是，0否")
    private Integer longTerm;

    @ApiModelProperty(value = "任务开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "任务结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "完成状态0未完成 1已完成")
    private Integer finishStatus;

    @ApiModelProperty(value = "调查问卷任务 - 调查问卷模板code")
    private String contentQuestionnaireTemplateCode;
}
