package com.bizvane.mktcenter.feign.vo.req;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class QueryTaskPopupAdvertisementPageReqVO extends PageVO {

    @ApiModelProperty(value = "广告名称")
    private String advertisementName;

    @ApiModelProperty(value = "投放状态 1待投放 2投放中 3已结束 4已关闭")
    private Integer popupStatus;

    @ApiModelProperty(value = "投放开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "投放结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "创建时间from")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateStart;

    @ApiModelProperty(value = "创建时间end")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateEnd;

    @ApiModelProperty(value = "创建人名称")
    private String createUserName;
}
