package com.bizvane.mktcenter.feign.vo.req;

import com.bizvane.mktcenter.feign.vo.CouponDefVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class AddOrUpdateMktActivityFortuneWheelPrizeReqVO {

    @ApiModelProperty(value = "大转盘活动奖项系统编号code")
    private String mktActivityFortuneWheelPrizeCode;

    @ApiModelProperty(value = "关联大转盘活动系统编号code")
    private String mktActivityFortuneWheelCode;

    @ApiModelProperty(value = "关联活动系统code")
    private String mktActivityCode;

    @ApiModelProperty(value = "奖项等级 0安慰奖 1奖项一 2奖项二 3奖项三...")
    private Integer prizeLevel;

    @ApiModelProperty(value = "奖项名称")
    private String prizeName;

    @ApiModelProperty(value = "奖项类型 1积分奖励 2优惠券奖励 3实物奖励")
    private Integer prizeType;

    @ApiModelProperty(value = "奖励积分数")
    private Integer prizeIntegral;

    @ApiModelProperty(value = "优惠券奖励 逗号分隔")
    private List<AddOrUpdateMktActivityFortuneWheelPrizeCouponReqVO> prizeCouponCodeList;

    @ApiModelProperty(value = "奖品图片img")
    private String prizeImg;

    @ApiModelProperty(value = "奖励数量限制类型 0不限制 1限制")
    private Integer prizeNumLimitType;

    @ApiModelProperty(value = "奖励数量限制")
    private Integer prizeNumLimit;

    @ApiModelProperty(value = "每人中奖上限限制类型 0不限制 1限制")
    private Integer prizeWinNumPerType;

    @ApiModelProperty(value = "每人中奖上限限制数量")
    private Integer prizeWinNumPer;

    @ApiModelProperty(value = "每人中奖限制类型（前几次不能中奖） 0不限制 1限制")
    private Integer prizeWinBeforeNumPerType;

    @ApiModelProperty(value = "每人中奖限制数量")
    private Integer prizeWinBeforeNumPer;

    @ApiModelProperty(value = "每日中奖限制类型 0不限制 1限制")
    private Integer prizeWinBeforeNumEverydayType;

    @ApiModelProperty(value = "每日中奖限制数量")
    private Integer prizeWinBeforeNumEveryday;

    @ApiModelProperty(value = "中奖白名单类型 0不限制 1指定等级 2导入名单")
    private Integer prizeWhiteListType;

    @ApiModelProperty(value = "白名单等级code 逗号分隔")
    private List<String> prizeWhiteListLevelCodeList;

    @ApiModelProperty(value = "奖励出现开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime prizeStartTime;

    @ApiModelProperty(value = "奖励出现结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime prizeEndTime;

    @ApiModelProperty(value = "奖项概率‰")
    private Integer prizeProbability;

    @ApiModelProperty(value = "导入白名单会员编号")
    private List<String> memberCodeWhiteList;
}
