package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.mktcenter.feign.vo.req.ClickPopupAdvertisementReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryMobilePopupAdvertisementListReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryMobilePopupAdvertisementListRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/taskPopupAdvertisement")
public interface MobileTaskPopupAdvertisementFeign {
    @PostMapping("/getList")
    ResponseData<List<QueryMobilePopupAdvertisementListRespVO>> getList(@RequestBody QueryMobilePopupAdvertisementListReqVO reqVO);

    @PostMapping("/clickPopupAdvertisement")
    ResponseData<String> clickPopupAdvertisement(@RequestBody ClickPopupAdvertisementReqVO reqVO);
}
