package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.members.feign.model.vo.MbrPropertyVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskDetailReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailTaskImproveProfileRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/improveProfile")
public interface MobileImproveProfileFeign {
    @PostMapping("/getProfileList")
    public ResponseData<QueryDetailTaskImproveProfileRespVO> getProfileList(@RequestBody QueryTaskDetailReqVO reqVO);
    @PostMapping("/getProfileListByMemberCode")
    public ResponseData<QueryDetailTaskImproveProfileRespVO> getProfileListByMemberCode(@RequestBody MbrPropertyVO mbrPropertyVO);
    }
