package com.bizvane.mktcenter.feign.vo.resp.mobile;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class QueryManualPageRespVO {

    @ApiModelProperty(value = "活动系统编号code")
    private String mktActivityCode;

    @ApiModelProperty(value = "活动名称")
    private String activityName;

    @ApiModelProperty(value = "是否长期：1是，0否")
    private Integer longTerm;

    @ApiModelProperty(value = "活动开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "活动结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "券列表")
    private List<QueryManualCouponRespVO> couponDefList;
}
