package com.bizvane.mktcenter.feign.vo.resp;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = false)
public class QueryTaskPopupAdvertisementPageRespVO {

    @ApiModelProperty(value = "弹窗广告系统code")
    private String popupAdvertisementCode;

    @ApiModelProperty(value = "会员条件类型  1全部会员 2会员分组")
    private Integer mbrConditionType;

    @ApiModelProperty(value = "关联的会员分组系统code")
    private String mbrGroupDefCode;

    @ApiModelProperty(value = "投放页面：1.会员中心首页")
    private Integer popupWebType;

    @ApiModelProperty(value = "投放开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String startTime;

    @ApiModelProperty(value = "投放结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String endTime;

    @ApiModelProperty(value = "投放频率：0=永久一次；1=每次进入")
    private Integer frequencyType;

    @ApiModelProperty(value = "广告名称")
    private String advertisementName;

    @ApiModelProperty(value = "广告图片路径")
    private String advertisementImgUrl;

    @ApiModelProperty(value = "图片高度，单位px")
    private Integer popupImgHeight;

    @ApiModelProperty(value = "图片宽度，单位px")
    private Integer popupImgWeight;

    @ApiModelProperty(value = "跳转路径")
    private String linkUrl;

    @ApiModelProperty(value = "跳转路径名称")
    private String linkUrlName;

    @ApiModelProperty(value = "曝光次数")
    private Integer popupNum;

    @ApiModelProperty(value = "点击次数")
    private Integer clickNum;

    @ApiModelProperty(value = "点击率")
    private String clickRate;

    @ApiModelProperty(value = "上架状态 0下架 1上架，")
    private Integer status;

    @ApiModelProperty(value = "投放状态 1待投放 2投放中 3已结束 4已关闭")
    private Integer popupStatus;

    @ApiModelProperty(value = "优先级:值越小，越靠前")
    private Integer sort;

    @ApiModelProperty(value = "审核状态：1待审核，2审核中，3已审核，4已驳回， 5审核关闭")
    private Integer checkStatus;

    @ApiModelProperty(value = "审核备注")
    private String checkRemark;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String createDate;

    @ApiModelProperty(value = "创建人名称")
    private String createUserName;
}
