package com.bizvane.mktcenter.feign.vo.resp;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class QueryMktTaskPageRespVO {

    @ApiModelProperty(value = "任务系统编号code")
    private String mktTaskCode;

    @ApiModelProperty(value = "任务编号")
    private String taskNo;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "是否长期：1是，0否")
    private Integer longTerm;

    @ApiModelProperty(value = "任务开始时间")
    private String startTime;

    @ApiModelProperty(value = "任务结束时间")
    private String endTime;

    @ApiModelProperty(value = "审核状态：1待审核，2审核中，3已审核，4已驳回， 5审核关闭")
    private Integer checkStatus;

    @ApiModelProperty(value = "审核备注")
    private String checkRemark;

    @ApiModelProperty(value = "审核人系统code")
    private String checkUserCode;

    @ApiModelProperty(value = "审核人名称")
    private String checkUserName;

    @ApiModelProperty(value = "任务状态：1待执行，2执行中，3已结束，4已禁用")
    private Integer taskStatus;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "创建人名称")
    private String createUserName;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime modifiedDate;

    @ApiModelProperty(value = "更新人名称")
    private String modifiedUserName;

}
