package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.*;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityLotteryRecordRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityPointsLotteryAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityPointLotteryRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailPointsLotteryRuleRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 活动表-积分夺宝活动 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-16
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivityPointsLottery")
public interface TMktActivityPointsLotteryFeign {
    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktActivityPointLotteryReqVO reqVO);

    @PostMapping("/analysisPageList")
    ResponseData<PageInfo<QueryActivityPointsLotteryAnalysisPageRespVO>> analysisPageList(@RequestBody QueryActivityAnalysisPageReqVO reqVO);

    @PostMapping("/getDetail")
    ResponseData<QueryDetailActivityPointLotteryRespVO> getDetail(@RequestBody QueryActivityDetailReqVO reqVO);

    @PostMapping("/pageListRecord")
    ResponseData<PageInfo<QueryActivityLotteryRecordRespVO>> pageListRecord(@RequestBody QueryActivityLotteryRecordReqVO reqVO);

    @PostMapping("/saveRule")
    ResponseData<String> saveRule(@RequestBody AddOrUpdatePointsLotteryRuleReqVO reqVO);

    @GetMapping("/getRule")
    ResponseData<QueryDetailPointsLotteryRuleRespVO> getRule();
}

