package com.bizvane.mktcenter.feign.constants;

import lombok.Getter;

@Getter
public enum ActivityStatusEnum {
    ACTIVITY_STATUS_PENDING(1, "未开始"),
    ACTIVITY_STATUS_EXECUTING(2, "进行中"),
    ACTIVITY_STATUS_FINISHED(3, "已结束"),
    ACTIVITY_STATUS_DISABLED(4, "已暂停");

    final private int code;
    final private String name;

    ActivityStatusEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ActivityStatusEnum getActivityStatusEnum(int code) {
        for (ActivityStatusEnum activityStatusEnum : ActivityStatusEnum.values()) {
            if (activityStatusEnum.getCode() == code) {
                return activityStatusEnum;
            }
        }
        return null;
    }
}
