package com.bizvane.mktcenter.feign.constants;

import lombok.Getter;

@Getter
public enum ActivityOrTaskCheckStatusEnum {
    AUDIT_STATUS_PENDING(1, "待审核"),
    AUDIT_STATUS_AUDITING(2, "审核中"),
    AUDIT_STATUS_AUDITED(3, "已审核"),
    AUDIT_STATUS_REJECTED(4, "已驳回"),
    AUDIT_STATUS_CLOSED(5, "审核关闭");

    final private int code;
    final private String name;

    ActivityOrTaskCheckStatusEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ActivityOrTaskCheckStatusEnum getCheckStatusEnum(int code) {
        for (ActivityOrTaskCheckStatusEnum checkStatusEnum : ActivityOrTaskCheckStatusEnum.values()) {
            if (checkStatusEnum.getCode() == code) {
                return checkStatusEnum;
            }
        }
        return null;
    }
}
