package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktTaskSurveyReqVO;
import com.bizvane.mktcenter.feign.vo.req.CompleteSurveyReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailTaskSurveyRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskSurveyAnalysisPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 营销任务 - 问卷调查 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-22
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktTaskSurvey")
public interface TMktTaskSurveyFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktTaskSurveyReqVO reqVO);

    @PostMapping("/analysisPageList")
    ResponseData<PageInfo<QueryTaskSurveyAnalysisPageRespVO>> analysisPageList(@RequestBody QueryTaskAnalysisPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailTaskSurveyRespVO> getDetail(@RequestParam("mktTaskCode") String mktTaskCode);

    @ApiOperation(value = "完成问卷调查")
    @PostMapping("/completeSurvey")
    ResponseData<String> completeSurvey(@RequestBody CompleteSurveyReqVO completeSurveyBO);

}

