package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.DisableReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryPageTaskPageReqVO;
import com.bizvane.mktcenter.feign.vo.req.UpdateTaskCheckStatusReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskInviteRegisterPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * <p>
 * 营销任务主表 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-17
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktTask")
public interface TMktTaskFeign {

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryTaskInviteRegisterPageRespVO>> pageList(@RequestBody QueryPageTaskPageReqVO reqVO);

    @PostMapping("/disableTask")
    ResponseData<String> disableTask(@RequestBody DisableReqVO reqVO);

    @ApiOperation(value = "更新任务审核状态")
    @PostMapping("/updateTaskCheckStatus")
    ResponseData<String> updateTaskCheckStatus(@RequestBody UpdateTaskCheckStatusReqVO reqVO);

}

