package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktOrderRegisterReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityOrderAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityOrderRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 活动表-会员消费 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-11
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivityOrder")
public interface TMktActivityOrderFeign {
    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktOrderRegisterReqVO reqVO);

    @PostMapping("/pageAnalysisList")
    ResponseData<PageInfo<QueryActivityOrderAnalysisPageRespVO>> pageAnalysisList(@RequestBody QueryActivityAnalysisPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailActivityOrderRespVO> getDetail(@RequestParam("mktActivityCode") String mktActivityCode);
}

