package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivityFortuneWheelReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryFortuneWheelWinRecordReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityFortuneWheelAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityFortuneWheelRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryFortuneWheelWinRecordRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 活动表-幸运大转盘 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-25
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivityFortuneWheel")
public interface TMktActivityFortuneWheelFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktActivityFortuneWheelReqVO reqVO);

    @PostMapping("/analysisPageList")
    ResponseData<PageInfo<QueryActivityFortuneWheelAnalysisPageRespVO>> analysisPageList(@RequestBody QueryActivityAnalysisPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailActivityFortuneWheelRespVO> getDetail(@RequestParam("mktActivityCode") String mktActivityCode);

    @PostMapping("/winRecordPageInfo")
    ResponseData<PageInfo<QueryFortuneWheelWinRecordRespVO>> winRecordPageInfo(@RequestBody QueryFortuneWheelWinRecordReqVO reqVO);

}

