package com.bizvane.mktcenter.feign.constants;

import lombok.Getter;

public class Constants {

    @Getter
    public enum ActivityStatusEnum {
        ACTIVITY_STATUS_PENDING(1, "未开始"),
        ACTIVITY_STATUS_EXECUTING(2, "进行中"),
        ACTIVITY_STATUS_FINISHED(3, "已结束"),
        ACTIVITY_STATUS_DISABLED(4, "已暂停");

        final private int code;
        final private String name;

        ActivityStatusEnum(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public static ActivityStatusEnum getActivityStatusEnum(int code) {
            for (ActivityStatusEnum activityStatusEnum : ActivityStatusEnum.values()) {
                if (activityStatusEnum.getCode() == code) {
                    return activityStatusEnum;
                }
            }
            return null;
        }
    }

    @Getter
    public enum ActivityCheckStatusEnum {
        AUDIT_STATUS_PENDING(1, "待审核"),
        AUDIT_STATUS_AUDITING(2, "审核中"),
        AUDIT_STATUS_AUDITED(3, "已审核"),
        AUDIT_STATUS_REJECTED(4, "已驳回"),
        AUDIT_STATUS_CLOSED(5, "审核关闭");

        final private int code;
        final private String name;

        ActivityCheckStatusEnum(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public static ActivityCheckStatusEnum getCheckStatusEnum(int code) {
            for (ActivityCheckStatusEnum checkStatusEnum : ActivityCheckStatusEnum.values()) {
                if (checkStatusEnum.getCode() == code) {
                    return checkStatusEnum;
                }
            }
            return null;
        }
    }

    @Getter
    public enum MktMbrConditionTypeEnum {
        // 会员条件类型  1全部会员 2会员分组 3会员等级
        ACTIVITY_MBR_CONDITION_TYPE_ALL(1, "全部会员"),
        ACTIVITY_MBR_CONDITION_TYPE_GROUP(2, "会员分组"),
        ACTIVITY_MBR_CONDITION_TYPE_LEVEL(3, "会员等级");

        final private int code;
        final private String name;

        MktMbrConditionTypeEnum(int code, String name) {
            this.code = code;
            this.name = name;
        }
    }

    @Getter
    public enum MktBatchSendMessageTypeEnum {
        // 营销 - 消息群发 消息群发任务类型 1微信小程序订阅消息2短信消息3站内消息
        SEND_MESSAGE_TYPE_MINI_PROGRAM(1, "微信小程序订阅消息"),
        SEND_MESSAGE_TYPE_SMS(2, "短信消息"),
        SEND_MESSAGE_TYPE_SITE(3, "站内消息");

        final private int code;
        final private String name;

        MktBatchSendMessageTypeEnum(int code, String name) {
            this.code = code;
            this.name = name;
        }
    }
}
