/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.utils;

import java.io.IOException;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrongJsoup {
    private static final Logger log = LoggerFactory.getLogger(StrongJsoup.class);
    private static final int TIMEOUT = 60000;
    private Connection conn;
    private String url;
    private int retryTime = 3;

    private StrongJsoup(String url) {
        this.url = url;
        this.conn = Jsoup.connect((String)url).timeout(60000).ignoreContentType(true).userAgent("Mozilla/5.0 (Windows NT 5.2) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.122 Safari/534.30");
    }

    public static StrongJsoup connect(String url) {
        return new StrongJsoup(url);
    }

    public Connection getJsoupConn() {
        return this.conn;
    }

    public StrongJsoup headers(Map<String, String> headers) {
        for (Map.Entry<String, String> e : headers.entrySet()) {
            this.conn.header(e.getKey(), e.getValue());
        }
        return this;
    }

    public Document post(int retryTime) {
        this.retryTime = retryTime;
        return this.post();
    }

    public Document get(int retryTime) {
        this.retryTime = retryTime;
        return this.get();
    }

    public Document get() {
        for (int i = 0; i < this.retryTime; ++i) {
            try {
                return this.conn.method(Connection.Method.GET).get();
            }
            catch (IOException e) {
                if (i + 1 >= this.retryTime) continue;
                log.warn("\u8bf7\u6c42[" + this.url + "]\u5931\u8d25[" + i + "]\uff0c\u7ee7\u7eed\u91cd\u8bd5", (Throwable)e);
                continue;
            }
        }
        throw new RuntimeException("\u8bf7\u6c42[" + this.url + "]\u5931\u8d25[" + this.retryTime + "]\u6b21");
    }

    public Document post() {
        for (int i = 0; i < this.retryTime; ++i) {
            try {
                return this.conn.method(Connection.Method.POST).post();
            }
            catch (IOException e) {
                if (i + 1 >= this.retryTime) continue;
                log.error("\u8bf7\u6c42[" + this.url + "]\u5931\u8d25[" + i + "]\uff0c\u7ee7\u7eed\u91cd\u8bd5", (Throwable)e);
                continue;
            }
        }
        throw new RuntimeException("\u8bf7\u6c42[" + this.url + "]\u5931\u8d25[" + this.retryTime + "]\u6b21");
    }
}

