/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.component;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.base.common.bean.SmsResBean;
import com.bizvane.message.cache.entity.ChannelConfigCache;
import com.bizvane.message.component.BaseComponent;
import com.bizvane.message.component.BatchOperationMessage;
import com.bizvane.message.component.MessageAccount;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.component.bean.SignatureBean;
import com.bizvane.message.component.bean.SmsInternationResBean;
import com.bizvane.message.component.bean.SmsSendResponse;
import com.bizvane.message.component.bean.SmsVariableResponse;
import com.bizvane.message.component.bean.TemplateBean;
import com.bizvane.message.utils.ChuangLanComUtil;
import com.bizvane.message.utils.ChuangLanSmsUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="CHUANGLAN_STRATEGY")
public class ChuangLanSmsComponent
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(ChuangLanSmsComponent.class);
    @Value(value="${chuanglan.signature.remindphone}")
    private String remindPhone;

    public TemplateBean callUpdateTemplate(ChannelConfigCache channelConfig, String templateName, String content, String templateType, String remark, String templateCode, String sign, String postFix) throws MessageException {
        TemplateBean templateBean;
        String accountJson = channelConfig.getAccountJson();
        MessageAccount messageAccount = (MessageAccount)JSON.parseArray((String)accountJson, MessageAccount.class).get(0);
        try {
            String res = ChuangLanComUtil.createTemplate((String)messageAccount.getAppid(), (String)messageAccount.getSubid(), (String)messageAccount.getDeepUsername(), (String)messageAccount.getDeepPassword(), (String)content, (String)remark, (String)messageAccount.getType(), (String)templateCode, (String)sign, (String)postFix);
            log.info("\u521b\u84dd\u66f4\u65b0\u6a21\u677f\u54cd\u5e94:{}", (Object)res);
            JSONObject jsonObject = JSONObject.parseObject((String)res);
            if (!"success".equals(jsonObject.getString("status"))) {
                log.info("\u521b\u84dd\u66f4\u65b0\u6a21\u677f\u5931\u8d25:{}", (Object)jsonObject.toJSONString());
                throw MessageException.newBuilder().errCode(jsonObject.getString("code")).errCodeDes(jsonObject.getString("msg")).build();
            }
            JSONObject data = jsonObject.getJSONObject("data");
            templateBean = TemplateBean.builder().templateCode(data.getString("id")).templateName(templateName).build();
        }
        catch (IOException e) {
            log.error("\u521b\u84dd\u77ed\u4fe1\u6a21\u7248\u66f4\u65b0server\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_ERROR.getErrCode()).errCodeDes("\u521b\u84dd\u66f4\u65b0\u6a21\u677fserver:" + e.getMessage()).build();
        }
        log.info("\u521b\u84dd\u66f4\u65b0\u6a21\u677f\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)templateBean));
        return templateBean;
    }

    @Deprecated
    public TemplateBean callDeleteTemplate(ChannelConfigCache channelConfig, String templateCode) throws MessageException {
        TemplateBean templateBean;
        String accountJson = channelConfig.getAccountJson();
        MessageAccount messageAccount = (MessageAccount)JSON.parseArray((String)accountJson, MessageAccount.class).get(0);
        try {
            String text = ChuangLanComUtil.deleteTemplate((String)messageAccount.getAppid(), (String)messageAccount.getSubid(), (String)messageAccount.getDeepUsername(), (String)messageAccount.getDeepPassword(), (String)templateCode);
            log.info("\u521b\u84dd\u5220\u9664\u6a21\u677f\u54cd\u5e94:{}", (Object)text);
            JSONObject jsonObject = JSONObject.parseObject((String)text);
            if (!"success".equals(jsonObject.getString("status"))) {
                log.info("\u521b\u84dd\u5220\u9664\u6a21\u677f\u5931\u8d25:{}", (Object)jsonObject.toJSONString());
                throw MessageException.newBuilder().errCode(jsonObject.getString("code")).errCodeDes(jsonObject.getString("msg")).build();
            }
            templateBean = TemplateBean.builder().templateCode(templateCode).build();
        }
        catch (IOException e) {
            log.error("\u521b\u84dd\u77ed\u4fe1\u6a21\u7248\u5220\u9664server\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_ERROR.getErrCode()).errCodeDes("\u521b\u84dd\u5220\u9664\u6a21\u677fserver:" + e.getMessage()).build();
        }
        log.info("\u521b\u84dd\u5220\u9664\u6a21\u677f\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)templateBean));
        return templateBean;
    }

    public TemplateBean callCreateTemplate(ChannelConfigCache channelConfig, String templateName, String templateType, String content, String remark, String sign, String postFix) throws MessageException {
        TemplateBean templateBean;
        String accountJson = channelConfig.getAccountJson();
        MessageAccount messageAccount = (MessageAccount)JSON.parseArray((String)accountJson, MessageAccount.class).get(0);
        try {
            String text = ChuangLanComUtil.createTemplate((String)messageAccount.getAppid(), (String)messageAccount.getSubid(), (String)messageAccount.getDeepUsername(), (String)messageAccount.getDeepPassword(), (String)content, (String)remark, (String)messageAccount.getType(), null, (String)sign, (String)postFix);
            log.info("\u521b\u84dd\u521b\u5efa\u6a21\u677f\u54cd\u5e94:{}", (Object)text);
            JSONObject jsonObject = JSONObject.parseObject((String)text);
            if (!"success".equals(jsonObject.getString("status"))) {
                log.info("\u521b\u84dd\u521b\u5efa\u6a21\u677f\u5931\u8d25:{}", (Object)jsonObject.toJSONString());
                throw MessageException.newBuilder().errCode(jsonObject.getString("code")).errCodeDes(jsonObject.getString("msg")).build();
            }
            JSONObject data = jsonObject.getJSONObject("data");
            templateBean = TemplateBean.builder().templateCode(data.getString("id")).templateName(templateName).status("0").remark(remark).createTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")).auditReason("").templateType(templateType).signature(sign).unsubscribe(messageAccount.getAccessKeyId().startsWith("Y") ? " \u56deT\u9000\u8ba2" : "").content(messageAccount.getAccessKeyId().startsWith("Y") ? content.concat(" \u56deT\u9000\u8ba2") : content).build();
        }
        catch (IOException e) {
            log.error("\u521b\u84dd\u77ed\u4fe1\u6a21\u7248\u521b\u5efaserver\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_ERROR.getErrCode()).errCodeDes("\u521b\u84dd\u521b\u5efa\u6a21\u677fserver:" + e.getMessage()).build();
        }
        log.info("\u521b\u84dd\u521b\u5efa\u6a21\u677f\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)templateBean));
        return templateBean;
    }

    public TemplateBean callQueryTemplate(ChannelConfigCache channelConfig, String templateId) throws MessageException {
        TemplateBean templateBean;
        String accountJson = channelConfig.getAccountJson();
        MessageAccount messageAccount = (MessageAccount)JSON.parseArray((String)accountJson, MessageAccount.class).get(0);
        try {
            String text = ChuangLanComUtil.getTemplate((String)messageAccount.getAppid(), (String)messageAccount.getSubid(), (String)messageAccount.getDeepUsername(), (String)messageAccount.getDeepPassword(), (String)templateId);
            log.info("\u521b\u84dd\u67e5\u8be2\u6a21\u677f\u54cd\u5e94:{}", (Object)text);
            JSONObject jsonObject = JSONObject.parseObject((String)text);
            if (!"success".equals(jsonObject.getString("status"))) {
                log.info("\u521b\u84dd\u67e5\u8be2\u6a21\u677f\u5931\u8d25:{}", (Object)jsonObject.toJSONString());
                throw MessageException.newBuilder().errCode(jsonObject.getString("code")).errCodeDes(jsonObject.getString("msg")).build();
            }
            JSONObject data = jsonObject.getJSONObject("data");
            templateBean = TemplateBean.builder().templateCode(data.getString("id")).accountId(data.getString("account_id")).remark(data.getString("remark")).signature(data.getString("signature")).content(data.getString("content")).status(data.getString("status")).auditDate(data.getString("audit_date")).auditReason(data.getString("audit_reason")).unsubscribe(data.getString("unsubscribe")).remoteId(data.getString("remote_id")).statusDesc(data.getString("status_desc")).build();
            templateBean.setTemplateType(ChuangLanSmsComponent.convertType((String)messageAccount.getAppid()));
        }
        catch (IOException e) {
            log.error("\u521b\u84dd\u67e5\u8be2\u6a21\u677fserver\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_ERROR.getErrCode()).errCodeDes("\u521b\u84dd\u67e5\u8be2\u6a21\u677fserver:" + e.getMessage()).build();
        }
        log.info("\u521b\u84dd\u67e5\u8be2\u6a21\u677f\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)templateBean));
        return templateBean;
    }

    private static String convertType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        String convertType = "52".equals(type) ? "2" : ("49".equals(type) ? "1" : ("153".equals(type) ? "0" : "3"));
        log.info("\u5c06type:{}\u8f6c\u6362\u4e3aconvertType:{}", (Object)type, (Object)convertType);
        return convertType;
    }

    public SignatureBean callCreateSignature(ChannelConfigCache channelConfig, String signName, String signSource, String remark, String fileSuffix, String fileContents, String sceneType, String isOnline, String webSite, String app) throws MessageException {
        SignatureBean signatureBean;
        String accountJson = channelConfig.getAccountJson();
        MessageAccount messageAccount = (MessageAccount)JSON.parseArray((String)accountJson, MessageAccount.class).get(0);
        try {
            String text = ChuangLanComUtil.createSignature((String)messageAccount.getAppid(), (String)messageAccount.getSubid(), (String)messageAccount.getDeepUsername(), (String)messageAccount.getDeepPassword(), (String)signName, (String)fileContents, (String)sceneType, (String)isOnline, (String)webSite, (String)app, (String)"1", (String)this.remindPhone);
            log.info("\u521b\u84dd\u521b\u5efa\u7b7e\u540d\u54cd\u5e94:{}", (Object)text);
            JSONObject jsonObject = JSONObject.parseObject((String)text);
            if (!"success".equals(jsonObject.getString("status"))) {
                log.info("\u521b\u84dd\u521b\u5efa\u7b7e\u540d\u5931\u8d25:{}", (Object)jsonObject.toJSONString());
                throw MessageException.newBuilder().errCode(jsonObject.getString("code")).errCodeDes(jsonObject.getString("msg")).build();
            }
            JSONObject data = jsonObject.getJSONObject("data");
            signatureBean = SignatureBean.builder().signid(data.getString("id")).signName(signName).build();
        }
        catch (IOException e) {
            log.error("\u521b\u84dd\u521b\u5efa\u7b7e\u540d\u67e5\u8be2server\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_ERROR.getErrCode()).errCodeDes("\u521b\u84dd\u521b\u5efa\u7b7e\u540dserver:" + e.getMessage()).build();
        }
        log.info("\u521b\u84dd\u521b\u5efa\u7b7e\u540d\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)signatureBean));
        return signatureBean;
    }

    @Deprecated
    public SignatureBean callUpdateSignature(ChannelConfigCache channelConfig, String signName, String signSource, String remark, String fileSuffix, String fileContents) throws MessageException {
        return null;
    }

    public SignatureBean callDeleteSignature(ChannelConfigCache channelConfig, String sigName, String signatureId) throws MessageException {
        SignatureBean signatureBean;
        if (StringUtils.isBlank((CharSequence)signatureId)) {
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_SIGID_NOT_EMPTY.getErrCode()).errCodeDes(BizvaneExceptionEnum.CHUANGLAN_SIGID_NOT_EMPTY.getErrCodeDes()).build();
        }
        String accountJson = channelConfig.getAccountJson();
        MessageAccount messageAccount = (MessageAccount)JSON.parseArray((String)accountJson, MessageAccount.class).get(0);
        try {
            String text = ChuangLanComUtil.deleteSignature((String)messageAccount.getAppid(), (String)messageAccount.getSubid(), (String)messageAccount.getDeepUsername(), (String)messageAccount.getDeepPassword(), (String)signatureId);
            log.info("\u521b\u84dd\u5220\u9664\u7b7e\u540d\u54cd\u5e94:{}", (Object)text);
            JSONObject jsonObject = JSONObject.parseObject((String)text);
            if (!"success".equals(jsonObject.getString("status"))) {
                log.info("\u521b\u84dd\u5220\u9664\u7b7e\u540d\u5931\u8d25:{}", (Object)jsonObject.toJSONString());
                throw MessageException.newBuilder().errCode(jsonObject.getString("code")).errCodeDes(jsonObject.getString("msg")).build();
            }
            signatureBean = SignatureBean.builder().signName(sigName).signid(signatureId).build();
        }
        catch (IOException e) {
            log.error("\u521b\u84dd\u5220\u9664\u7b7e\u540d\u67e5\u8be2server\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_ERROR.getErrCode()).errCodeDes("\u521b\u84dd\u5220\u9664\u7b7e\u540dserver:" + e.getMessage()).build();
        }
        log.info("\u521b\u84dd\u5220\u9664\u7b7e\u540d\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)signatureBean));
        return signatureBean;
    }

    @Deprecated
    public SignatureBean callQuerySignature(ChannelConfigCache channelConfig) throws MessageException {
        return null;
    }

    public SmsResBean callSendSms(ChannelConfigCache channelConfig, String phones, String templateCode, Map<String, String> param, String templateContent, String signature, String batchid) throws MessageException {
        List account = JSON.parseArray((String)channelConfig.getAccountJson(), MessageAccount.class);
        Assert.notNull((Object)account);
        MessageAccount messageAccount = (MessageAccount)account.get(0);
        templateContent = new StringBuffer("\u3010").append(signature).append("\u3011").append(templateContent).toString();
        String paramJson = ChuangLanSmsUtil.getParamJson((String)messageAccount.getAccessKeyId(), (String)messageAccount.getSecret(), (String)templateContent, param, (String)phones, (String)templateCode, (String)(channelConfig.getMerchantId() + "_" + batchid));
        log.info("\u521b\u84dd\u53d1\u9001\u77ed\u4fe1\u5165\u53c2:{}", (Object)paramJson);
        if (messageAccount.getAccessKeyId().startsWith("I")) {
            return this.sendSmsInternation(paramJson, false);
        }
        return this.sendSmsDomestic(param, paramJson);
    }

    private SmsResBean sendSmsInternation(String paramJson, boolean isBatch) throws MessageException {
        SmsInternationResBean smsInternationResBean;
        log.info("\u521b\u84dd\u53d1\u9001\u56fd\u9645\u77ed\u4fe1");
        try {
            if (!isBatch) {
                log.info("\u5355\u4e2a\u53d1\u9001");
                smsInternationResBean = ChuangLanSmsUtil.sendInternationSms((String)paramJson);
            } else {
                log.info("\u6279\u91cf\u53d1\u9001");
                smsInternationResBean = ChuangLanSmsUtil.sendInternationSmsBatch((String)paramJson);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u84dd\u53d1\u9001\u56fd\u9645\u77ed\u4fe1\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_ERROR.getErrCode()).errCodeDes("\u53d1\u9001\u77ed\u4fe1Server:" + e.getMessage()).build();
        }
        log.info("\u521b\u84dd\u53d1\u9001\u56fd\u9645\u77ed\u4fe1\u8fd4\u56de\u53c2\u6570:{}", JSON.toJSON((Object)smsInternationResBean));
        return this.commonResponse(smsInternationResBean);
    }

    private SmsResBean sendSmsDomestic(Map<String, String> param, String paramJson) throws MessageException {
        try {
            if (param != null && param.size() > 0) {
                log.info("\u53d1\u9001\u666e\u901a\u53d8\u91cf\u77ed\u4fe1:{}", (Object)paramJson);
                SmsVariableResponse smsResvari = ChuangLanSmsUtil.sendVariableSms((String)paramJson);
                log.info("\u521b\u84dd\u53d1\u9001\u666e\u901a\u53d8\u91cf\u77ed\u4fe1\u8fd4\u56de\u53c2\u6570:{}", JSON.toJSON((Object)smsResvari));
                return this.commonResponse(smsResvari);
            }
            log.info("\u53d1\u9001\u666e\u901a\u77ed\u4fe1:{}", (Object)paramJson);
            SmsSendResponse smsRes = ChuangLanSmsUtil.sendSms((String)paramJson);
            log.info("\u521b\u84dd\u53d1\u9001\u666e\u901a\u77ed\u4fe1\u8fd4\u56de\u53c2\u6570:{}", JSON.toJSON((Object)smsRes));
            return this.commonResponse(smsRes);
        }
        catch (Exception e) {
            log.error("\u521b\u84dd\u53d1\u9001\u56fd\u5185\u77ed\u4fe1\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHUANGLAN_ERROR.getErrCode()).errCodeDes("\u53d1\u9001\u77ed\u4fe1Server:" + e.getMessage()).build();
        }
    }

    public SmsResBean callSendSmsBatch(ChannelConfigCache channelConfig, String templateCode, String templateContent, List<BatchOperationMessage> list, List<String> phones, String batchid) throws MessageException {
        List accounts = JSON.parseArray((String)channelConfig.getAccountJson(), MessageAccount.class);
        Assert.notNull((Object)accounts);
        MessageAccount messageAccount = (MessageAccount)accounts.get(0);
        templateContent = new StringBuffer("\u3010").append(list.get(0).getSignature()).append("\u3011").append(templateContent).toString();
        String paramJson = ChuangLanSmsUtil.getParamJson((String)messageAccount.getAccessKeyId(), (String)messageAccount.getSecret(), (String)templateContent, list, phones, (String)templateCode, (String)(channelConfig.getMerchantId() + "_" + batchid));
        log.info("\u521b\u84dd\u6279\u91cf\u53d1\u9001\u77ed\u4fe1\u5165\u53c2:{}", (Object)paramJson);
        if (messageAccount.getAccessKeyId().startsWith("I")) {
            return this.sendSmsInternation(paramJson, true);
        }
        return this.sendSmsDomestic(!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty((Map)list.get(0).getParams()) ? list.get(0).getParams() : null, paramJson);
    }

    @Deprecated
    public SmsResBean callQuerySms(ChannelConfigCache channelConfig, String phone, String sendDate, String pageSize, String currentPage, String requestId) {
        return null;
    }

    private SmsResBean commonResponse(SmsVariableResponse res) {
        return SmsResBean.builder().msgId(res.getMsgId()).time(ChuangLanSmsComponent.getTime((String)res.getTime())).failNum(res.getFailNum()).successNum(res.getSuccessNum()).errorCode(res.getCode()).errorReason(res.getErrorMsg()).build();
    }

    private static String getTime(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime time = LocalDateTime.parse(str, dtf);
        DateTimeFormatter dt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return time.format(dt);
    }

    private SmsResBean commonResponse(SmsSendResponse res) {
        return SmsResBean.builder().msgId(res.getMsgId()).time(res.getTime()).errorCode(res.getCode()).errorReason(res.getErrorMsg()).build();
    }

    private SmsResBean commonResponse(SmsInternationResBean res) {
        return SmsResBean.builder().msgId(res.getMsgid()).errorCode(res.getCode()).errorReason(res.getError()).build();
    }
}

