/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.cache.MerchantCacheCompoent;
import com.bizvane.message.cache.entity.MerchantCache;
import com.bizvane.message.component.bean.MessageCallBackDto;
import com.bizvane.message.service.inter.ICallBackMsgService;
import com.bizvane.message.utils.StrongJsoup;
import java.io.IOException;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CallBackComponent {
    private static final Logger log = LoggerFactory.getLogger(CallBackComponent.class);
    @Autowired
    private ICallBackMsgService callBackMsgService;
    @Autowired
    private MerchantCacheCompoent merchantCacheCompoent;

    public Boolean callBack(String merchantid, String channelType, String batchid, String dtoJson) throws IOException {
        log.info("\u77ed\u4fe1\u56de\u8c03\u5904\u7406\u8fdb\u5165:\u5904\u7406\u5b8c\u6210\u7684\u77ed\u4fe1\u901a\u77e5\u5165\u53c2\u662f:merchantid:{},channelType:{},batchid:{},jsonStr:{}", new Object[]{merchantid, channelType, batchid, dtoJson});
        MessageCallBackDto dto = (MessageCallBackDto)JSON.parseObject((String)dtoJson, MessageCallBackDto.class);
        this.callBackMsgService.save(merchantid, channelType, dtoJson);
        MerchantCache merchantConfig = this.merchantCacheCompoent.getMerchant(merchantid);
        dto.setMerchantid(merchantid);
        dto.setChannleType(channelType);
        dto.setBatchid(batchid);
        log.info("url : " + merchantConfig.getNotifyUrl());
        Document post = StrongJsoup.connect((String)merchantConfig.getNotifyUrl()).getJsoupConn().ignoreContentType(true).ignoreHttpErrors(true).header("Content-Type", "application/json; charset=UTF-8").requestBody(JSON.toJSONString((Object)dto)).post();
        String a = post.text();
        log.info("\u56de\u8c03\u4e1a\u52a1\u65b9\u7684\u8fd4\u56de\u503c:{}", (Object)a);
        try {
            JSONObject json = JSONObject.parseObject((String)a);
            Integer isSuccess = json.getInteger("code");
            if (isSuccess != null && isSuccess == 0) {
                return true;
            }
        }
        catch (Exception e) {
            log.info("\u56de\u8c03\u4e1a\u52a1\u62a5\u9519{}:=={}::", (Object)a, (Object)e.getMessage());
        }
        return false;
    }
}

