/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service;

import com.alibaba.fastjson.JSON;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.message.cache.MerchantCacheCompoent;
import com.bizvane.message.cache.entity.MerchantCache;
import com.bizvane.message.component.bean.MessageCallBackDto;
import com.bizvane.message.component.bean.MessageNotifyStatusEnum;
import com.bizvane.message.dao.MessageFlowDao;
import com.bizvane.message.entity.MessageFlow;
import com.bizvane.message.service.inter.IMessageFlowService;
import com.bizvane.message.utils.StrongJsoup;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageFlowService
implements IMessageFlowService {
    private static final Logger log = LoggerFactory.getLogger(MessageFlowService.class);
    @Autowired
    private MessageFlowDao messageFlowDao;
    @Autowired
    private MerchantCacheCompoent merchantCacheCompoent;

    public void save(String merchantId, String channelId, String channelType, Integer status, String batchid, String phone, String messageId, String templateCode, String requestId, String errCode, String errorReason) {
        MessageFlow messageFlow = MessageFlow.builder().merchantId(merchantId).channelId(channelId).channelType(channelType).status(status).phone(phone).messageId(messageId).templateCode(templateCode).createTime(new Date()).requestId(requestId).code(errCode).reason(errorReason).build();
        try {
            if (StringUtils.isNotBlank((CharSequence)messageFlow.getPhone())) {
                if (messageFlow.getPhone().length() > 11) {
                    messageFlow.setPhone(DesensitizeUtil.encrypt((String)phone, (Integer)4, (Integer)4));
                } else {
                    messageFlow.setPhone(DesensitizeUtil.encrypt((String)phone));
                }
            }
            this.messageFlowDao.insert((Object)messageFlow);
            this.callBackNotify(merchantId, channelType, batchid, phone, requestId, errCode, errorReason);
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u6d41\u6c34\u8868\u4fdd\u5b58\u5931\u8d25:{},{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void callBackNotify(String merchantId, String channelType, String batchid, String phones, String requestId, String errCode, String errorReason) throws IOException {
        String[] phoneArr;
        if ("0".equals(errCode)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)batchid)) {
            return;
        }
        log.info("\u56de\u8c03\u4e1a\u52a1\u65b9\u7684phones:" + phones);
        if (phones.contains("[")) {
            phones = phones.replace("[", "");
        }
        if (phones.contains("]")) {
            phones = phones.replace("]", "");
        }
        MessageCallBackDto messageCallBackDto = new MessageCallBackDto();
        messageCallBackDto.setMerchantid(merchantId);
        messageCallBackDto.setChannleType(channelType);
        messageCallBackDto.setBatchid(batchid);
        messageCallBackDto.setStatusDesc(errorReason);
        if (StringUtils.isNotBlank((CharSequence)requestId)) {
            messageCallBackDto.setStatus(MessageNotifyStatusEnum.CHUANGLAN_REJECTED.getValue());
        } else {
            messageCallBackDto.setStatus(MessageNotifyStatusEnum.MESSAGE_UNKONW.getValue());
        }
        MerchantCache merchantConfig = this.merchantCacheCompoent.getMerchant(merchantId);
        for (String phone : phoneArr = StringUtils.split((String)phones, (String)",")) {
            log.info("\u56de\u8c03\u4e1a\u52a1\u65b9\u7684phone:" + phone);
            if (StringUtils.isBlank((CharSequence)phone)) continue;
            messageCallBackDto.setPhone(phone);
            log.info("\u56de\u8c03\u4e1a\u52a1\u65b9\u7684url:" + merchantConfig.getNotifyUrl());
            Document post = StrongJsoup.connect((String)merchantConfig.getNotifyUrl()).getJsoupConn().ignoreContentType(true).ignoreHttpErrors(true).header("Content-Type", "application/json; charset=UTF-8").requestBody(JSON.toJSONString((Object)messageCallBackDto)).post();
            log.info("\u56de\u8c03\u4e1a\u52a1\u65b9\u7684phone:{},\u8fd4\u56de\u503c:{}", (Object)phone, (Object)post.text());
        }
    }
}

