/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.client.web;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.cache.MerchantCacheCompoent;
import com.bizvane.message.component.CallBackComponent;
import com.bizvane.message.component.bean.ChuangLanCallBackResponse;
import com.bizvane.message.component.bean.ChuangLanCallBackResurtEnum;
import com.bizvane.message.component.bean.MessageCallBackDto;
import com.bizvane.message.component.bean.MessageNotifyStatusEnum;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import com.bizvane.message.utils.SplitNotifyMsgUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.HttpStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/chuanglan"})
public class ChuangLanSmsCallBackController {
    private static final Logger log = LoggerFactory.getLogger(ChuangLanSmsCallBackController.class);
    @Autowired
    private CallBackComponent callBackComponent;
    @Autowired
    private MerchantCacheCompoent merchantCacheCompoent;

    @GetMapping(value={"callback"})
    public ChuangLanCallBackResponse callbackDomestic(HttpServletRequest request, HttpServletResponse response) {
        ChuangLanCallBackResponse chuangLanCallBackResponse = new ChuangLanCallBackResponse();
        chuangLanCallBackResponse.setClcode(ChuangLanCallBackResurtEnum.FAIL.getCode());
        try {
            Map parameterMap = request.getParameterMap();
            String s = JSON.toJSONString((Object)parameterMap);
            log.info("\u521b\u84dd\u53d1\u9001\u56fd\u5185\u77ed\u4fe1\u56de\u8c03\u7ed3\u679c:{}", (Object)s);
            if (StringUtils.isNotBlank((CharSequence)s)) {
                MessageCallBackDto dto = ChuangLanSmsCallBackController.convertToDto((String)s);
                String midAndBid = this.merchantCacheCompoent.getBizMerchantRelation(dto.getMsgid());
                if (StringUtils.isNotBlank((CharSequence)midAndBid)) {
                    List split = SplitNotifyMsgUtil.split((String)midAndBid);
                    log.info("\u8fdb\u5165\u56de\u8c03\u7b2c\u4e09\u65b9\u65b9\u6cd5");
                    Boolean isSuccess = this.callBackComponent.callBack((String)split.get(0), MessageStrategyEnum.CHUANGLAN_STRATEGY.getType(), (String)split.get(1), JSON.toJSONString((Object)dto));
                    if (isSuccess.booleanValue()) {
                        chuangLanCallBackResponse.setClcode(ChuangLanCallBackResurtEnum.SUCCESS.getCode());
                    }
                } else {
                    log.info("\u6839\u636emsgId\u67e5\u4e0d\u5230\u4e1a\u52a1id,\u53ef\u80fd\u662f\u521b\u84dd\u56de\u8c03\u9519\u4e86");
                    chuangLanCallBackResponse.setClcode(ChuangLanCallBackResurtEnum.SUCCESS.getCode());
                }
            } else {
                log.info("\u521b\u84dd\u5165\u53c2\u4e3a\u7a7a");
                chuangLanCallBackResponse.setClcode(ChuangLanCallBackResurtEnum.SUCCESS.getCode());
            }
        }
        catch (HttpStatusException httpStatusException) {
            log.error("\u521b\u84ddcallback\u5f02\u5e38:{},StatusCode:{},url:{},{}", new Object[]{httpStatusException.getMessage(), httpStatusException.getStatusCode(), httpStatusException.getUrl(), httpStatusException});
        }
        catch (Exception e) {
            log.error("\u521b\u84ddcallback\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
        log.info(chuangLanCallBackResponse.getClcode());
        return chuangLanCallBackResponse;
    }

    private static MessageCallBackDto convertToDto(String s) {
        MessageCallBackDto dto = new MessageCallBackDto();
        JSONObject json = JSONObject.parseObject((String)s);
        String reportTime = json.getJSONArray("reportTime").getString(0);
        String substring = String.valueOf(DateUtil.thisYear()).substring(0, 2);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
        DateTime parse = DateUtil.parse((CharSequence)(substring + reportTime), (DateFormat)format);
        String time = parse.toString("yyyy-MM-dd HH:mm:ss");
        dto.setReportTime(time);
        dto.setLength(json.getJSONArray("length").getString(0));
        dto.setPhone(json.getJSONArray("mobile").getString(0));
        String status = json.getJSONArray("status").getString(0);
        String statusValue = MessageNotifyStatusEnum.getStatusValue((String)status);
        dto.setStatus(statusValue);
        dto.setStatusDesc(json.getJSONArray("statusDesc").getString(0));
        dto.setMsgid(json.getJSONArray("msgid").getString(0));
        return dto;
    }

    @GetMapping(value={"callbackInternation"})
    public String callbackInternation(HttpServletRequest request, HttpServletResponse response) {
        Map parameterMap = request.getParameterMap();
        String s = JSON.toJSONString((Object)parameterMap);
        log.info("\u521b\u84dd\u53d1\u9001\u56fd\u9645\u77ed\u4fe1\u56de\u8c03\u7ed3\u679c:{},merchantid:{}", (Object)s);
        try {
            MessageCallBackDto dto;
            String midAndBid;
            if (StringUtils.isNotBlank((CharSequence)s) && StringUtils.isNotBlank((CharSequence)(midAndBid = this.merchantCacheCompoent.getBizMerchantRelation((dto = ChuangLanSmsCallBackController.convertToDto((String)s)).getMsgid())))) {
                List split = SplitNotifyMsgUtil.split((String)midAndBid);
                log.info("\u8fdb\u5165\u56de\u8c03\u7b2c\u4e09\u65b9\u65b9\u6cd5");
                this.callBackComponent.callBack((String)split.get(0), MessageStrategyEnum.CHUANGLAN_STRATEGY.getType(), (String)split.get(1), JSON.toJSONString((Object)dto));
            }
        }
        catch (Exception e) {
            log.error("\u521b\u84ddcallbackInternation\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
        return "OK";
    }
}

