/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bizvane.message.cache.MerchantCacheCompoent;
import com.bizvane.message.cache.entity.MerchantCache;
import com.bizvane.message.dao.MerchantDao;
import com.bizvane.message.dao.MerchantSequenceDao;
import com.bizvane.message.entity.Merchant;
import com.bizvane.message.entity.MerchantSequence;
import com.bizvane.message.service.inter.IMerchantService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantService
implements IMerchantService {
    @Autowired
    private MerchantDao merchantDao;
    @Autowired
    private MerchantSequenceDao merchantSequenceDao;
    @Autowired
    private MerchantCacheCompoent merchantCacheCompoent;

    public Merchant saveMerchant(String companyName, String brandName, String notifyUrl) {
        MerchantSequence merchantSequence = new MerchantSequence();
        merchantSequence.setValue("1");
        this.merchantSequenceDao.insert((Object)merchantSequence);
        Merchant merchant = new Merchant();
        merchant.setMerchantId(String.format("%04d", merchantSequence.getId()));
        merchant.setBrandName(brandName);
        merchant.setCompanyName(companyName);
        merchant.setNotifyUrl(notifyUrl);
        merchant.setCreateDate(new Date());
        merchant.setUpdateDate(new Date());
        this.merchantDao.insert((Object)merchant);
        this.merchantCacheCompoent.saveMerchant(merchant);
        return merchant;
    }

    public Merchant updateMerchant(String merchantId, String companyName, String brandName, String notifyUrl) {
        Merchant merchant = new Merchant();
        merchant.setMerchantId(merchantId);
        merchant.setCompanyName(companyName);
        merchant.setBrandName(brandName);
        merchant.setNotifyUrl(notifyUrl);
        merchant.setUpdateDate(new Date());
        UpdateWrapper update = Wrappers.update();
        update.eq((Object)"merchant_id", (Object)merchantId);
        int result = this.merchantDao.update((Object)merchant, (Wrapper)update);
        if (result == 1) {
            this.merchantCacheCompoent.delete(merchantId);
            this.merchantCacheCompoent.saveMerchant(merchant);
        }
        return merchant;
    }

    public MerchantCache getMerchant(String merchantId) {
        MerchantCache merchantCache = this.merchantCacheCompoent.getMerchant(merchantId);
        return merchantCache;
    }

    public int deleteMerchant(String merchantId) {
        return this.merchantDao.updateValid(merchantId);
    }
}

