/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.client.web;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ErrorInfo;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.common.bean.SmsMqRequest;
import com.bizvane.base.common.bean.SmsReqBean;
import com.bizvane.message.component.annotation.SmsValid;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import com.bizvane.message.component.bean.TemplateTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message/sms"})
@Validated
public class RemoteSmsController {
    private static final Logger log = LoggerFactory.getLogger(RemoteSmsController.class);
    private static final String PT_TOPIC = "MESSAGE_SEND_NEW";
    private static final String VARCODE_TOPIC_SINGLE = "MESSAGE_SEND_VARCODE_SINGLE_NEW";
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    @RequestMapping(method={RequestMethod.POST}, value={"/marketing"}, produces={"application/json"})
    public ResultBean<String> marketingSms(@RequestBody @SmsValid SmsReqBean smsReqBean) {
        log.info("\u53d1\u9001\u8425\u9500\u77ed\u4fe1controller\u5165\u53c2:{}", JSON.toJSON((Object)smsReqBean));
        ResultBean result = new ResultBean();
        result.setSuccess(Boolean.valueOf(false));
        if (MessageStrategyEnum.CHUANGLAN_STRATEGY.getType().equals(smsReqBean.getChannelType())) {
            smsReqBean.setChannelTypeSuffix(TemplateTypeEnum.YX.getName());
        }
        SmsMqRequest mq = new SmsMqRequest();
        BeanUtils.copyProperties((Object)smsReqBean, (Object)mq);
        mq.setType(smsReqBean.getChannelType());
        try {
            this.rocketMQTemplate.asyncSend(new Destination(PT_TOPIC, mq.getType(), null), (Object)mq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u8425\u9500\u77ed\u4fe1\u5931\u8d25:{},{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCodeDes()));
            return result;
        }
        result.setSuccess(Boolean.valueOf(true));
        result.setResult((Object)"SUCCESS");
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/varCode"}, produces={"application/json"})
    public ResultBean<String> varCodeSms(@RequestBody @SmsValid SmsReqBean smsReqBean) {
        log.info("\u5355\u4e2a\u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1controller\u5165\u53c2:{}", JSON.toJSON((Object)smsReqBean));
        ResultBean result = new ResultBean();
        result.setSuccess(Boolean.valueOf(false));
        if (MessageStrategyEnum.CHUANGLAN_STRATEGY.getType().equals(smsReqBean.getChannelType())) {
            smsReqBean.setChannelTypeSuffix(TemplateTypeEnum.YZM.getName());
        }
        SmsMqRequest mq = new SmsMqRequest();
        BeanUtils.copyProperties((Object)smsReqBean, (Object)mq);
        mq.setType(smsReqBean.getChannelType());
        try {
            this.rocketMQTemplate.asyncSend(new Destination(VARCODE_TOPIC_SINGLE, mq.getType(), null), (Object)mq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1\u5931\u8d25:{},{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCodeDes()));
            return result;
        }
        result.setSuccess(Boolean.valueOf(true));
        result.setResult((Object)"SUCCESS");
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/notice"}, produces={"application/json"})
    public ResultBean<String> noticeSms(@RequestBody @SmsValid SmsReqBean smsReqBean) {
        log.info("\u53d1\u9001\u901a\u77e5\u77ed\u4fe1controller\u5165\u53c2:{}", JSON.toJSON((Object)smsReqBean));
        ResultBean result = new ResultBean();
        result.setSuccess(Boolean.valueOf(false));
        if (MessageStrategyEnum.CHUANGLAN_STRATEGY.getType().equals(smsReqBean.getChannelType())) {
            smsReqBean.setChannelTypeSuffix(TemplateTypeEnum.TZ.getName());
        }
        SmsMqRequest mq = new SmsMqRequest();
        BeanUtils.copyProperties((Object)smsReqBean, (Object)mq);
        mq.setType(smsReqBean.getChannelType());
        try {
            this.rocketMQTemplate.asyncSend(new Destination(PT_TOPIC, mq.getType(), null), (Object)mq);
        }
        catch (Exception e) {
            log.error("\u53d1\u53d1\u9001\u901a\u77e5\u77ed\u4fe1\u5931\u8d25:{},{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCodeDes()));
            return result;
        }
        result.setSuccess(Boolean.valueOf(true));
        result.setResult((Object)"SUCCESS");
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/marketingBatch"}, produces={"application/json"})
    public ResultBean<String> marketingSmsBatch(@RequestBody @SmsValid SmsReqBean smsReqBean) {
        log.info("\u6279\u91cf\u53d1\u9001\u8425\u9500\u77ed\u4fe1controller\u5165\u53c2:{}", JSON.toJSON((Object)smsReqBean));
        ResultBean result = new ResultBean();
        result.setSuccess(Boolean.valueOf(false));
        if (MessageStrategyEnum.CHUANGLAN_STRATEGY.getType().equals(smsReqBean.getChannelType())) {
            smsReqBean.setChannelTypeSuffix(TemplateTypeEnum.YX.getName());
        }
        SmsMqRequest mq = new SmsMqRequest();
        BeanUtils.copyProperties((Object)smsReqBean, (Object)mq);
        mq.setType(smsReqBean.getChannelType());
        mq.setBatchMessage("BATCH");
        try {
            this.rocketMQTemplate.asyncSend(new Destination(PT_TOPIC, mq.getType(), null), (Object)mq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6279\u91cf\u8425\u9500\u77ed\u4fe1\u5931\u8d25:{},{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCodeDes()));
            return result;
        }
        result.setSuccess(Boolean.valueOf(true));
        result.setResult((Object)"SUCCESS");
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/noticeBatch"}, produces={"application/json"})
    public ResultBean<String> noticeSmsBatch(@RequestBody @SmsValid SmsReqBean smsReqBean) {
        log.info("\u6279\u91cf\u53d1\u9001\u901a\u77e5\u77ed\u4fe1controller\u5165\u53c2:{}", JSON.toJSON((Object)smsReqBean));
        ResultBean result = new ResultBean();
        result.setSuccess(Boolean.valueOf(false));
        if (MessageStrategyEnum.CHUANGLAN_STRATEGY.getType().equals(smsReqBean.getChannelType())) {
            smsReqBean.setChannelTypeSuffix(TemplateTypeEnum.TZ.getName());
        }
        SmsMqRequest mq = new SmsMqRequest();
        BeanUtils.copyProperties((Object)smsReqBean, (Object)mq);
        mq.setType(smsReqBean.getChannelType());
        mq.setBatchMessage("BATCH");
        try {
            this.rocketMQTemplate.asyncSend(new Destination(PT_TOPIC, mq.getType(), null), (Object)mq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6279\u91cf\u901a\u77e5\u77ed\u4fe1\u5931\u8d25:{},{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_SEND_ERROR.getErrCodeDes()));
            return result;
        }
        result.setSuccess(Boolean.valueOf(true));
        result.setResult((Object)"SUCCESS");
        return result;
    }
}

