/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bizvane.message.cache.entity.MerchantCache;
import com.bizvane.message.dao.MerchantDao;
import com.bizvane.message.entity.Merchant;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MerchantCacheCompoent {
    private static final Logger log = LoggerFactory.getLogger(MerchantCacheCompoent.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private MerchantDao merchantDao;
    public static final String MESSAGE_MERCHANT_CONFIG = "message_gateway::merchant_config";
    public static final String MESSAGE_BIZ_MERCHANT_RELATION = "message_gateway::biz_merchant_relation::";
    public static final String GUODU_MESSAGE_BIZ_MERCHANT_RELATION = "message_gateway::biz_merchant_relation_guodu::";
    public static final String GUODU_MESSAGE_LENGTH = "message_gateway::biz_length_guodu::";
    public static final String GUODU_MESSAGE_SEND_STATUS = "message_gateway::length_status_guodu::";

    public MerchantCache getMerchant(String merchantId) {
        MerchantCache merchantCache = new MerchantCache();
        Object object = this.redisTemplate.opsForHash().get((Object)MESSAGE_MERCHANT_CONFIG, (Object)merchantId);
        if (Objects.nonNull(object)) {
            merchantCache = (MerchantCache)object;
            return merchantCache;
        }
        Merchant merchant = this.merchantDao.getMerchant(merchantId);
        if (Objects.nonNull(merchant)) {
            log.info("\u8d70\u6570\u636e\u5e93\u83b7\u53d6\u7684");
            BeanUtils.copyProperties((Object)merchant, (Object)merchantCache);
            this.saveMerchant(merchant);
            return merchantCache;
        }
        return null;
    }

    public MerchantCache saveMerchant(Merchant merchant) {
        MerchantCache merchantCache = new MerchantCache();
        BeanUtils.copyProperties((Object)merchant, (Object)merchantCache);
        this.redisTemplate.opsForHash().put((Object)MESSAGE_MERCHANT_CONFIG, (Object)merchant.getMerchantId(), (Object)merchantCache);
        return merchantCache;
    }

    public void delete(String merchantId) {
        this.redisTemplate.opsForHash().delete((Object)MESSAGE_MERCHANT_CONFIG, new Object[]{merchantId});
    }

    public String saveBizMerchantRelation(String bizId, String merchantid, String batchid) {
        log.info("\u4fdd\u5b58\u77ed\u4fe1\u4e1a\u52a1\u53f7\u548cMSGID\u7684\u5173\u7cfb:bizid:{}  merchantid:{}  batchid:{}", new Object[]{bizId, merchantid, batchid});
        if (!bizId.startsWith("=GUODU:")) {
            log.info("\u8fdb\u5165\u6807\u51c6\u83b7\u53d6\u5173\u7cfb\u6d41\u7a0b");
            this.redisTemplate.opsForValue().set((Object)(MESSAGE_BIZ_MERCHANT_RELATION + bizId), (Object)(merchantid + "_" + batchid), 3L, TimeUnit.DAYS);
        } else {
            log.info("\u8fdb\u5165\u56fd\u90fd\u83b7\u53d6\u5173\u7cfb\u6d41\u7a0b");
            String[] split = bizId.split("=GUODU:");
            String msgids = split[1];
            String countGroupByPhone = split[2];
            log.info("\u5904\u7406\u8fc7\u7684msgids:{}  countGroupByPhone:{}", (Object)msgids, (Object)countGroupByPhone);
            Map countPhone = (Map)JSON.parseObject((String)countGroupByPhone, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            List strings = Splitter.on((String)",").splitToList((CharSequence)msgids);
            if (!CollectionUtils.isEmpty((Map)countPhone)) {
                log.info("\u6b64\u6279\u77ed\u4fe1\uff0c\u4fdd\u5b58phone \u4e0e batchid\u5173\u7cfb\u7684\u6761\u6570\u662f:{}", (Object)countPhone.size());
                countPhone.entrySet().stream().forEach(e -> this.redisTemplate.opsForValue().set((Object)(GUODU_MESSAGE_LENGTH + (String)e.getKey() + "_" + batchid), e.getValue(), 3L, TimeUnit.DAYS));
            }
            if (!CollectionUtils.isEmpty((Collection)strings)) {
                log.info("\u6b64\u6279\u77ed\u4fe1\uff0c\u4fdd\u5b58msgid \u4e0ebatchid\u5173\u7cfb\u7684\u6761\u6570\u662f:{}", (Object)strings.size());
                strings.stream().forEach(e -> this.redisTemplate.opsForValue().set((Object)(GUODU_MESSAGE_BIZ_MERCHANT_RELATION + e), (Object)(merchantid + "_" + batchid), 3L, TimeUnit.DAYS));
            }
        }
        return bizId;
    }

    public String getBizMerchantRelation(String bizId) {
        log.info("\u67e5\u8be2bizid\u548cmerchantid\u4e4b\u95f4\u7684\u5173\u7cfb:bizId:{}", (Object)bizId);
        Object object = this.redisTemplate.opsForValue().get((Object)(MESSAGE_BIZ_MERCHANT_RELATION + bizId));
        log.info("\u67e5\u8be2bizid\u548cmerchantid\u4e4b\u95f4\u7684\u5173\u7cfb:{}", (Object)((String)object));
        if (StringUtils.isBlank((CharSequence)((String)object))) {
            log.info("\u53bb\u67e5\u4e00\u4e0b\u65e5\u5fd7:{},\u770b\u770b\u6709\u6ca1\u6709(\u6392\u67e5\u539f\u56e0\u662f\u672a\u4fdd\u5b58\u8fd8\u662f\u8fc7\u671f\u65f6\u95f4\u5df2\u7ecf\u5230\u4e86)", (Object)(MESSAGE_BIZ_MERCHANT_RELATION + bizId));
        }
        return (String)object;
    }

    public String getBizMerchantRelationGuodu(String bizId) {
        Object object = this.redisTemplate.opsForValue().get((Object)(GUODU_MESSAGE_BIZ_MERCHANT_RELATION + bizId));
        if (StringUtils.isBlank((CharSequence)((String)object))) {
            log.error("\u56fd\u90fd-\u5e76\u6ca1\u6709\u83b7\u53d6\u5230\u8be5\u77ed\u4fe1\u7684\u7684\u5173\u7cfb\u4fe1\u606f\uff0c,msgid:{}\uff0c\u6d41\u7a0b\u5f02\u5e38\u7ec8\u6b62", (Object)bizId);
        }
        log.info("\u56fd\u90fd-\u83b7\u53d6\u5230\u5173\u7cfb\u4fe1\u606f:midAndBatchid:{}", (Object)((String)object));
        return (String)object;
    }

    public Integer getLengthGuodu(String phone, String batchid) {
        Object object = this.redisTemplate.opsForValue().get((Object)(GUODU_MESSAGE_LENGTH + phone + "_" + batchid));
        if (object == null) {
            log.error("\u56fd\u90fd-\u5e76\u6ca1\u6709\u83b7\u53d6\u5230\u8be5\u77ed\u4fe1\u7684\u7684\u957f\u5ea6\u4fe1\u606f\uff0c\u53f7\u7801\u662f:{},batchid:{}\uff0c\u6d41\u7a0b\u5f02\u5e38\u7ec8\u6b62", (Object)phone, (Object)batchid);
        }
        log.info("\u56fd\u90fd-\u83b7\u53d6\u5230\u957f\u5ea6:{}", (Object)((Integer)object));
        return (Integer)object;
    }

    public boolean getLock(String phone, String batchid) {
        String key = GUODU_MESSAGE_SEND_STATUS + phone + "_" + batchid;
        if (this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"").booleanValue()) {
            this.redisTemplate.expire((Object)key, 3L, TimeUnit.DAYS);
            log.info("\u56fd\u90fd-\u77ed\u4fe1\u901a\u77e5\u5c06\u4f1a\u8fdb\u5165\u4e0b\u4e00\u6b65\u6d41\u7a0b\uff0c\u53f7\u7801\u662f:{},batchid:{}", (Object)phone, (Object)batchid);
            return true;
        }
        return false;
    }
}

