/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.cache.entity.ChannelConfigCache;
import com.bizvane.message.component.MessageAccount;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import com.bizvane.message.dao.ChannelDao;
import com.bizvane.message.entity.Channel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ChannelCacheComponent {
    private static final Logger log = LoggerFactory.getLogger(ChannelCacheComponent.class);
    @Autowired
    private ChannelDao channelDao;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    public static final String MESSAGE_CHANNEL_CONFIG = "message_gateway::channel_config";

    public ChannelConfigCache get(String merchantId, String channelType, String channelTypeSuffix) throws MessageException {
        log.info("\u7f13\u5b58get\u5165\u53c2:merchantId:{},channelType:{},channelTypeSuffix:{}", new Object[]{merchantId, channelType, channelTypeSuffix});
        String key = merchantId.concat("_").concat(StringUtils.isBlank((CharSequence)channelTypeSuffix) ? channelType : channelType + "_" + channelTypeSuffix);
        Object object = this.redisTemplate.opsForHash().get((Object)MESSAGE_CHANNEL_CONFIG, (Object)key);
        ChannelConfigCache channelConfigCache = new ChannelConfigCache();
        if (object != null) {
            channelConfigCache = (ChannelConfigCache)object;
            log.info("\u8d70\u7f13\u5b58\u83b7\u53d6\u7684\u7ed3\u679c:{}", JSON.toJSON((Object)channelConfigCache));
            return channelConfigCache;
        }
        boolean existFlag = false;
        Channel channel = this.channelDao.get(merchantId, channelType);
        if (channel != null) {
            log.info("\u8d70\u6570\u636e\u5e93\u83b7\u53d6\u7684\u7ed3\u679c:{}", JSON.toJSON((Object)channel));
            if (StringUtils.isNotBlank((CharSequence)channelTypeSuffix)) {
                List accounts = JSON.parseArray((String)channel.getAccountJson(), MessageAccount.class);
                for (MessageAccount account : accounts) {
                    if (!account.getType().equals(channelTypeSuffix)) continue;
                    ArrayList<MessageAccount> list = new ArrayList<MessageAccount>(1);
                    list.add(account);
                    channel.setAccountJson(JSON.toJSONString(list));
                    existFlag = true;
                }
            }
            if (!existFlag) {
                throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHANNEL_CONFIG_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.CHANNEL_CONFIG_ERROR.getErrCodeDes()).build();
            }
            BeanUtils.copyProperties((Object)channel, (Object)channelConfigCache);
            this.save(channel);
            return channelConfigCache;
        }
        log.info("\u7f13\u5b58\u8fd4\u56denull");
        return null;
    }

    public ChannelConfigCache save(Channel channel) {
        ChannelConfigCache config = new ChannelConfigCache();
        String key = channel.getMerchantId().concat("_").concat(channel.getChannelType());
        if (MessageStrategyEnum.CHUANGLAN_STRATEGY.getType().equals(channel.getChannelType())) {
            key = key.concat("_").concat(((MessageAccount)JSONObject.parseArray((String)channel.getAccountJson(), MessageAccount.class).get(0)).getType());
        }
        BeanUtils.copyProperties((Object)channel, (Object)config);
        log.info("redis\u4fdd\u5b58\u7684channle:{}", JSON.toJSON((Object)config));
        this.redisTemplate.opsForHash().put((Object)MESSAGE_CHANNEL_CONFIG, (Object)key, (Object)config);
        return config;
    }
}

