package com.bizvane.messagefacade.models.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author yuantq
 * @date 2022/8/17
 */
@Data
public class WeChatAppletSubscribeSentRecordDTO {

    private Long sysCompanyId;
    /**
     * 品牌ID
     */
    @NotNull(message = "sysBrandId 不能为空")
    private Long sysBrandId;

    private Long sysAccountId;

    /**
     * 会员卡号
     */
    private String cardNo;

    /**
     * 会员手机号
     */
    private String phone;

    /**
     * 消息类型
     */
    private String templateType;

    /**
     * openId
     */
    private String openId;

    /**
     * 发送开始日期
     */
    private Date startDate;

    /**
     * 发送结束日期
     */
    private Date endDate;

    /**
     * 消息发送状态 success-成功，fail-失败
     */
    private String sendStatus;

    private Integer pageNumber = 1;

    private Integer pageSize = 10;
}
