package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagefacade.models.vo.MsgTemplateSendConfigVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 获取短信模板
 * @author Bizvane
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/tempLateSendConfig")
public interface MsgTemplateSendConfigServiceFeign {

    @PostMapping("/add")
    ResponseData add(@RequestBody MsgTemplateSendConfigVO vo);

    @PostMapping("/findOne")
    ResponseData<MsgTemplateSendConfigVO> findOne(@RequestBody MsgTemplateSendConfigVO vo);

    @PostMapping("/find")
    ResponseData<List<MsgTemplateSendConfigVO>> find(@RequestBody MsgTemplateSendConfigVO vo);

    @PostMapping("/findPage")
    ResponseData<PageInfo<MsgTemplateSendConfigVO>> getMsgLogPage(@RequestBody MsgTemplateSendConfigVO vo);

}