package com.bizvane.messagefacade.utils;

import com.bizvane.messagefacade.enums.MsgWxTuwenSendStatusEnum;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 微信图文消息发送状态-状态值名称转换Handler
 * @author huangxinliu
 * @date: 2021/1/15 17:58
 */
public class MsgWxTuwenSendStateNameTypeHandler implements TypeHandler<String> {

    @Override
    public void setParameter(PreparedStatement preparedStatement, int i, String s, JdbcType jdbcType) throws SQLException {

    }

    @Override
    public String getResult(ResultSet resultSet, String s) throws SQLException {
        return MsgWxTuwenSendStatusEnum.getMsg(resultSet.getInt(s));
    }

    @Override
    public String getResult(ResultSet resultSet, int i) throws SQLException {
        return MsgWxTuwenSendStatusEnum.getMsg(resultSet.getInt(i));
    }

    @Override
    public String getResult(CallableStatement callableStatement, int i) throws SQLException {
        return MsgWxTuwenSendStatusEnum.getMsg(callableStatement.getInt(i));
    }
}
