package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagebase.model.vo.*;
import com.bizvane.messagefacade.models.vo.MsgWxTempMessageVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.validation.Valid;

/**
 * 消息模块标准接口,不处理任何消息的拼接,直接拿到消息发送.
 */
@FeignClient(value="${feign.client.message.name}",path = "${feign.client.message.path}/standardMessage")
public interface StandardMessageSmsFeign {

    /**
     * 立即发送短信,不走mq,直接调三方接口
     * @param standardMessageVo
     * @return
     */
    @RequestMapping(value = "/sendSingleMessageImmediately")
    ResponseData sendSingleMessageImmediately(@RequestBody StandardMessageVo standardMessageVo)  ;

    /**
     * 单张走mq
     * @param standardMessageVo
     * @return
     */
    @RequestMapping(value = "/sendSingleMessage")
    ResponseData sendSingleMessage(@RequestBody StandardMessageVo standardMessageVo)  ;

    /**
     * 批量走mq
     * @param standardMessageVo
     * @return
     */
    @RequestMapping(value = "/sendBatchMessage")
    ResponseData sendBatchMessage(@RequestBody StandardMessageVo standardMessageVo)  ;

    /**
     * 批量发送sms消息
     * @param vo
     * @return
     */
    @PostMapping(value = "/sendSmsBatchMessage")
    ResponseData sendSmsBatchMessage(@RequestBody @Valid StandardBatchMessageVO vo);

    /**
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "/sendBatchSendWxTemplateMsgForCdpMessage")
    ResponseData sendBatchSendWxTemplateMsgForCdpMessage(@RequestBody @Valid BatchSendWxTemplateForCdpVO vo);

    /**
     * 批量发送wechat消息
     * @param vo
     * @return
     */
    @PostMapping(value = "/sendWechatBatchMessage")
    ResponseData sendWechatBatchMessage(@RequestBody @Valid StandardBatchMessageVO vo);

    /**
     * 根据品牌id和消息类型查找对应的模板内容
     */
    @RequestMapping(value = "/getTemplate")
    ResponseData<String> getTemplateByBrandIdAndTemType(@RequestBody StandardTemplateVo standardTemplateVo);

    /**
     * 根据品牌id和模板类型获取模板
     */
    @RequestMapping(value = "/getTemplateByTemType")
    ResponseData<MsgWxTempMessageVO> getTemplateByTemType(@RequestBody StandardTemplateVo standardTemplateVo);


    @RequestMapping(value = "/getTemplateInfoByTempType")
    ResponseData<StandardTemplateResponseVO> getTemplateInfoByTempType(@RequestBody StandardTemplateVo standardTemplateVo);

}
