package com.bizvane.messagefacade.enums.subscribefield;

import com.bizvane.messagefacade.enums.WeChatSubscribeFieldEnum;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yuantq
 * @date 2022/8/23
 */
public enum ActivityBeginFieldEnum {

    FIELD_1("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE", WeChatSubscribeFieldEnum.MEMBER_CARD_NO, "FIELD_MEMBER_CARD_NO", Boolean.TRUE),
    FIELD_2("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE", WeChatSubscribeFieldEnum.ACTIVITY_NAME, "FIELD_ACTIVITY_NAME", Boolean.TRUE),
    FIELD_3("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE", WeChatSubscribeFieldEnum.ACTIVITY_START_TIME, "FIELD_ACTIVITY_START_TIME", Boolean.TRUE),
    FIELD_4("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE", WeChatSubscribeFieldEnum.ACTIVITY_EXPLAIN, "FIELD_ACTIVITY_EXPLAIN"),
    FIELD_5("ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE", WeChatSubscribeFieldEnum.TEXT, "FIELD_TEXT");

    private String menuCode;

    private WeChatSubscribeFieldEnum weChatSubscribeFieldEnum;

    private String jsonField;

    private Boolean mustNotNull = Boolean.FALSE;

    ActivityBeginFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
    }

    ActivityBeginFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField, Boolean mustNotNull) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
        this.mustNotNull = mustNotNull;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public WeChatSubscribeFieldEnum getWeChatSubscribeFieldEnum() {
        return weChatSubscribeFieldEnum;
    }

    public String getJsonField() {
        return jsonField;
    }

    public Boolean getMustNotNull() {
        return mustNotNull;
    }

    public static List<String> mustFieldList() {
        return Arrays.stream(ActivityBeginFieldEnum.values()).filter(e -> e.getMustNotNull()).map(ActivityBeginFieldEnum::getJsonField).collect(Collectors.toList());
    }

    public static Map<String, String> codeConvertJsonFieldMap() {
        return Arrays.stream(ActivityBeginFieldEnum.values()).collect(Collectors.toMap(e -> e.getWeChatSubscribeFieldEnum().getFieldCode(), ActivityBeginFieldEnum::getJsonField, (a, b) -> b));
    }

}
