package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 航班信息表
 * </p>
 *
 * @author Trump
 * @since 2024-12-24
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class BasicFlightFocusQueryRsp implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("航班信息code")
    private String basicFlightCode;

    @ApiModelProperty("航班号全称")
    private String flightIdentity;

    @ApiModelProperty("航班日期yyyy-MM-dd")
    private String flightDate;

    @ApiModelProperty("始发机场 IATA")
    private String iataOriginAirport;

    @ApiModelProperty("始发机场中文简称")
    private String cnOriginAirport;

    @ApiModelProperty("目的机场 IATA")
    private String destinationAirport;

    @ApiModelProperty("目的机场中文")
    private String cnDestinationAirport;

    @ApiModelProperty("预计起飞时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime estimatedTakeOffDateTime;

    @ApiModelProperty("预计落地时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime estimatedLandingDateTime;

    @ApiModelProperty("航空公司(承运人)二字码")
    private String airlineIataCode;

    @ApiModelProperty("航空公司logo")
    private String airlinesLogo;

    @ApiModelProperty("航空公司中文简称")
    private String airlineCn;

    @ApiModelProperty("FlightDirection 和 FlightRoute 至少必填一项，A - 到港，D - 离港")
    private String flightDirection;

    @ApiModelProperty("原始航班状态中文")
    private String flightStatusCn;

    @ApiModelProperty("关注来源：1-总线，2-小程序，3-外部小程序")
    private Integer focusSource;

    @ApiModelProperty("关注状态：1.关注、2.取消关注")
    private Integer focusStatus;

    @ApiModelProperty("行程记录code")
    private String mbrFlightRecordCode;
}
