package com.bizvane.members.feign.model.bo;

import com.bizvane.utils.enumutils.ChannelEnum;
import com.bizvane.utils.enumutils.SourceEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponEntityUseRequestParam {

    @ApiModelProperty("券号")
    @NotBlank
    private String couponNo;

    @ApiModelProperty("使用类型：1-crm系统，2-外部系统")
    private Integer useType;

    @ApiModelProperty("核销渠道code")
    private String useChannelCode = ChannelEnum.WECHAT.getType();

    @ApiModelProperty("核销来源code")
    private String useSourceCode = SourceEnum.LOVE.getType();

    @ApiModelProperty("核销人的会员code")
    @NotBlank
    private String useMemberCode;

    @ApiModelProperty("核销机场编号")
    private String useAirportNo;

    @ApiModelProperty("核销业态编号")
    private String useIndustryNo;

    @ApiModelProperty("核销商户编号")
    private String useMerchantNo;

    @ApiModelProperty("券使用订单号")
    private String useBusinessCode;

    @ApiModelProperty("券使用订单金额")
    private BigDecimal useBusinessAmount;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountPrice;

    @ApiModelProperty("使用时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime useTime;

    @ApiModelProperty("核销唯一凭据，虹桥商业POS专用")
    private String verifyCode;

    @ApiModelProperty("员工核销状态：true-员工核销，false-非员工核销")
    private Boolean useStaffStatus;

}
