package com.bizvane.members.feign.model.mq;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrSecuInfoMQ implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("航班记录code")
    private String mbrFlightRecordCode;

    @ApiModelProperty("航班号")
    private String flightIdentity;

    @ApiModelProperty("航班计划日期yyyy-MM-dd")
    private String flightScheduledDate;

    @ApiModelProperty("始发机场 IATA")
    private String iataOriginAirport;

    @ApiModelProperty("目的机场 IATA")
    private String iataDestinationAirport;

    @ApiModelProperty("目的机场国家类型：国内，国际")
    private String destinationAirportCountryType;

    @ApiModelProperty("转签标识 0 - 没转签 1 - 有转签")
    private String endorsement;

    @ApiModelProperty("转签前航班号，比如：CA1345，有可能为空")
    private String orgFlightIdentity;

    @ApiModelProperty("转签前航班日期 yyyy-MM-dd，有可能为空")
    private String orgFlightDate;

    @ApiModelProperty("转签前航班旅客登机号，有可能为空")
    private String orgFlightBoardno;

    @ApiModelProperty("安检状态：1-通过，2-退出")
    private int result;

}
