package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 外部券汇总表code
 * </p>
 *
 * @author Trump
 * @since 2024-11-06
 */
@Data
public class CouponExternalRecordVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("外部券记录表code")
    private String couponExternalRecordCode;

    @ApiModelProperty("外部券汇总表code")
    private String couponExternalSumCode;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("券定义code")
    private String couponDefinitionCode;

    @ApiModelProperty("状态：false-不可用，true-可用")
    private Boolean status;

    @ApiModelProperty("核销code，无业务含义")
    private String useCode;

    @ApiModelProperty("导入状态：false-失败，true-成功")
    private Boolean importStatus;

    @ApiModelProperty("发放状态：true-已发放，false-未发放")
    private Boolean sendStatus;

    @ApiModelProperty("失败原因")
    private String failDetail;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifiedDate;
}
