package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.BasicFlightQueryRsp;
import com.bizvane.members.feign.model.vo.FlightRecordVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/basicFlight")
@Api("航班信息管理")
public interface BasicFlightFeign {

  @ApiOperation(value = "新增航班", notes = "新增航班", tags = {"新增航班"},httpMethod = "POST")
  @RequestMapping(value="/save", method = RequestMethod.POST)
  ResponseData<String> save(@RequestBody @Valid BasicFlightSaveReq req);

  @ApiOperation(value = "查询航班列表", notes = "查询航班列表", tags = {"查询航班列表"},httpMethod = "POST")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<List<BasicFlightQueryRsp>> list(@RequestBody @Valid BasicFlightQueryReq bo);
}
