package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class FlightRecordVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("航班记录code")
    private String mbrFlightRecordCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("关注人身份：1.乘机人，2.接机人，3.送机人")
    private Integer focusType;

    @ApiModelProperty("关注状态：1.关注、2.取消关注")
    private Integer focusStatus;

    @ApiModelProperty("航班信息code")
    private String basicFlightCode;

    @ApiModelProperty("航班日期")
    private String flightDate;

    @ApiModelProperty("预计起飞时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime estimatedTakeOffDateTime;

    @ApiModelProperty("预计落地时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime estimatedLandingDateTime;

    @ApiModelProperty("航班号")
    private String flightIdentity;

    @ApiModelProperty("航班类型：D-国内, I-国际, R地区, M-混合")
    private String flightCountryType;

    @ApiModelProperty("航空公司(承运人)二字码")
    private String airlineIataCode;

    @ApiModelProperty("航空公司logo")
    private String airlinesLogo;

    @ApiModelProperty("航空公司中文简称")
    private String airlineCn;

    @ApiModelProperty("始发机场 IATA")
    private String iataOriginAirport;

    @ApiModelProperty("始发机场中文简称")
    private String cnOriginAirport;

    @ApiModelProperty("目的机场 IATA")
    private String iataDestinationAirport;

    @ApiModelProperty("目的机场中文")
    private String cnDestinationAirport;

    @ApiModelProperty("旅客主舱位信息")
    private String class1;

    @ApiModelProperty("座位号")
    private String seatNo;

    @ApiModelProperty("行李总件数")
    private Integer bags;

    @ApiModelProperty("行李总重量(Kg)")
    private BigDecimal bagsWeight;

    @ApiModelProperty("逗号分隔的行李提取转盘列表")
    private String baggageReclaims;

    @ApiModelProperty("航班状态：1-待出行, 5-飞行中, 10-已取消, 15-已完成")
    private Integer flightStatus;

    @ApiModelProperty("中转类型：1-国内到达，2-国际到达，3-国内中转国内，4-国内中转国际，5-国际中转国内，6-国际中转国际")
    private Integer transitType;

    @ApiModelProperty("中转旅客标识：1-中转，2-非中转")
    private String isTransit;

    @ApiModelProperty("中转间隔（单位：分钟）")
    private Long transitIntervalMinutes;

    @ApiModelProperty("中转航班信息code")
    private String transitBasicFlightCode;

    @ApiModelProperty("中转对象")
    private FlightRecordVO transitFlightRecordVO;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;
}
