package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>
 * 航班信息表
 * </p>
 *
 * @author Trump
 * @since 2024-12-24
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class BasicFlightQueryReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("航班号全称")
    private String flightIdentity;

    @ApiModelProperty("航班日期yyyy-MM-dd")
    private String flightDate;

    @ApiModelProperty("目的机场 IATA")
    private String destinationAirport;

    @ApiModelProperty("航班类型：A-到港，D-离港")
    private String flightDirection;

    @ApiModelProperty("登机门编号")
    private String gates;
}
