package com.bizvane.members.feign.model.bo;

import com.bizvane.utils.enumutils.SysOrderByEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrMemberListRequestParam {

    @ApiModelProperty("会员code集合")
    private List<String> mbrMembersCodeList = new ArrayList<>();

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号加密")
    private String phoneEncrypt;

    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("类型,1:冻结 2: 解冻")
    private Integer cardStatus;

    @ApiModelProperty("开卡时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime openCardTimeStart;

    @ApiModelProperty("开卡时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime openCardTimeEnd;

    @ApiModelProperty("生日时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime birthdateStart;

    @ApiModelProperty("生日时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime birthdateEnd;

    @ApiModelProperty("来源：调字典接口typeCode传mbr_source")
    private String sourceCode;

    @ApiModelProperty("注册明细类型：调字典接口typeCode传register_detail_type")
    private Integer detailType;

    private Long minId;

    private int pageNum = 1;

    private int pageSize  = 10;

    private SysOrderByEnum orderByEnum = SysOrderByEnum.DESC;
}
