package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.FlightRecordListRequestParam;
import com.bizvane.members.feign.model.bo.MbrFlightRecordAddReq;
import com.bizvane.members.feign.model.bo.MbrFlightRecordFocusReq;
import com.bizvane.members.feign.model.vo.FlightRecordVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/flightRecord")
@Api("航班记录管理")
public interface FlightRecordFeign {

  @ApiOperation(value = "新增航班记录", notes = "新增航班记录", tags = {"新增航班记录航班记录"},httpMethod = "POST")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<String> add(@RequestBody @Valid MbrFlightRecordAddReq bo);

  @ApiOperation(value = "会员关注航班同步", notes = "会员关注航班同步", tags = {"会员关注航班同步"},httpMethod = "POST")
  @RequestMapping(value="/focusFlightSync", method = RequestMethod.POST)
  ResponseData<String> focusFlightSync(@RequestBody @Valid MbrFlightRecordFocusReq bo);

  @ApiOperation(value = "查询航班记录列表", notes = "查询航班记录列表", tags = {"查询航班记录列表接口"},httpMethod = "POST")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<PageInfo<FlightRecordVO>> list(@RequestBody FlightRecordListRequestParam param);


  @ApiOperation(value = "新增航班记录详情", notes = "新增航班记录详情", tags = {"新增航班记录详情接口"},httpMethod = "POST")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  ResponseData<FlightRecordVO> detail(@RequestParam("mbrFlightRecordCode") @NotNull String mbrFlightRecordCode);


}
