package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrFlightRecordFocusReq {

    @NotBlank(message = "会员code不能为空")
    @ApiModelProperty(value = "会员表code", example = "mbrMembersCode100", required = true)
    private String mbrMembersCode;

    @NotBlank(message = "关注航班号不能为空")
    @ApiModelProperty(value = "关注航班号", example = "203049029FSGsdg", required = true)
    private String focusFlightNo;

    @ApiModelProperty(value = "关注航班时间（格式：yyyy-MM-dd）", example = "2024-12-01", required = true)
    @NotBlank(message = "关注航班时间不能为空")
    private String focusFlightTime;

    @ApiModelProperty(value = "关注人身份：1.乘机人，2.接机人，3.送机人", example = "1", required = true)
    @NotNull(message = "关注人身份不能为空")
    private Integer focusType;

    @ApiModelProperty(value = "同步类型：1.关注、2.取消关注", example = "1", required = true)
    @NotNull(message = "同步类型不能为空")
    private Integer syncType;

    @ApiModelProperty(value = "始发机场 IATA", example = "HAK", required = true)
    @NotBlank(message = "始发机场不能为空")
    private String iataOriginAirport;

    @ApiModelProperty(value = "目的机场 IATA", example = "NGB", required = true)
    @NotBlank(message = "目的机场不能为空")
    private String iataDestinationAirport;

    @ApiModelProperty("关注优先级：1-总线，2-小程序，3-外部小程序")
    private Integer focusLevel;
}
