package com.bizvane.members.feign.model.vo;

import com.bizvane.members.feign.model.bo.OrderDetailBO;
import com.bizvane.members.feign.model.bo.OrderPaymentBO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class OrderDetailVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("code")
    private String mbrOrderCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("是否会员订单：1-是，0-否")
    private Boolean memberOrder;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("订单标志：1-订单，2-退单")
    private Integer orderFlag;

    @ApiModelProperty("原始订单号")
    private String originalOrderNo;

    @ApiModelProperty("订单类型：1-商户订单，2-停车订单，3-酒店订单，4-贵宾服务，5-机场管家")
    private Integer orderType;

    @ApiModelProperty("订单状态，商业订单1-19，酒店订单20-29，贵宾服务30-39，机场管家40-49：1-待付款, 2-待发货, 3-已发货, 4-已签收, 5-交易成功, 6-退款中, 7-退款成功, 8-交易关闭，20-待确认，21-已确认，22-已入住，30-待付款，31-待使用，40-待确认，41-服务中")
    private String orderStatus;

    @ApiModelProperty("评价状态：false-未评价，true-已评价")
    private Boolean reviewStatus;

    @ApiModelProperty("完成时间")
    private LocalDateTime finishTime;

    @ApiModelProperty("订单金额")
    private BigDecimal tradeAmount;

    @ApiModelProperty("商品数量")
    private Integer productCount;

    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime placeOrderTime;

    @ApiModelProperty("支付时间 ")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime payTime;

    @ApiModelProperty("支付金额")
    private BigDecimal payMoney;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("行业")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;

    @ApiModelProperty("订单明细")
    private List<OrderDetailBO> orderDetailList;

    @ApiModelProperty("支付明细")
    private List<OrderPaymentBO> orderPaymentList;
}
