package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;

@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class MbrIntegralSubRequestParam {

    @NotBlank
    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("变更单据")
    private String changeBills;

    @ApiModelProperty("变更来源")
    private String changeSource;

    @ApiModelProperty("变更积分")
    private Integer changeIntegral;

    @ApiModelProperty("变动时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime changeDate;

    @ApiModelProperty("变更详情")
    private String changeDetails;

    @NotBlank
    @ApiModelProperty("业务类型：枚举IntegralBusinessWayEnum，字典integral_business_way")
    private Integer businessWay;

    @NotBlank
    @ApiModelProperty("业务code，需要全局唯一")
    private String businessCode;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("行业")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("使用流水code集合（如果传值，优先从传的流水中扣积分）")
    private List<String> mbrIntegralRecordCodeList;

    @ApiModelProperty("是否允许负数")
    private Boolean allowNegative;

    @ApiModelProperty("修改人code")
    private String userCode;

    @ApiModelProperty("修改人")
    private String userName;

}
