package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponEntityRevertRequestParam {

    @ApiModelProperty("券号")
    @NotBlank
    private String couponNo;

    @ApiModelProperty("会员code")
    @NotBlank
    private String mbrMembersCode;

    @ApiModelProperty("撤销时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime revertTime;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;

}
